/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public abstract class TextFieldListEntry<T>
extends TooltipListEntry<T> {
    protected EditBox textFieldWidget;
    protected Button resetButton;
    protected Supplier<T> defaultValue;
    protected T original;
    protected List<AbstractWidget> widgets;
    private boolean isSelected = false;

    @Deprecated
    @ApiStatus.Internal
    protected TextFieldListEntry(Component fieldName, T original, Component resetButtonKey, Supplier<T> defaultValue) {
        this(fieldName, original, resetButtonKey, defaultValue, null);
    }

    @Deprecated
    @ApiStatus.Internal
    protected TextFieldListEntry(Component fieldName, T original, Component resetButtonKey, Supplier<T> defaultValue, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, original, resetButtonKey, defaultValue, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    protected TextFieldListEntry(Component fieldName, T original, Component resetButtonKey, Supplier<T> defaultValue, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.original = original;
        this.textFieldWidget = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 148, 18, (Component)Component.m_237119_()){

            public void m_6305_(PoseStack matrices, int int_1, int int_2, float float_1) {
                this.m_93692_(TextFieldListEntry.this.isSelected && TextFieldListEntry.this.m_7222_() == this);
                TextFieldListEntry.this.textFieldPreRender(this);
                super.m_6305_(matrices, int_1, int_2, float_1);
            }

            public void m_94164_(String string_1) {
                super.m_94164_(TextFieldListEntry.this.stripAddText(string_1));
            }
        };
        this.textFieldWidget.m_94199_(999999);
        this.textFieldWidget.m_94144_(String.valueOf(original));
        this.resetButton = new Button(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)resetButtonKey) + 6, 20, resetButtonKey, widget -> this.textFieldWidget.m_94144_(String.valueOf(defaultValue.get())));
        this.widgets = Lists.newArrayList((Object[])new AbstractWidget[]{this.textFieldWidget, this.resetButton});
    }

    @Override
    public boolean isEdited() {
        return this.isChanged(this.original, this.textFieldWidget.m_94155_());
    }

    protected boolean isChanged(T original, String s) {
        return !String.valueOf(original).equals(s);
    }

    protected static void setTextFieldWidth(EditBox widget, int width) {
        widget.m_93674_(width);
    }

    @Deprecated
    public void setValue(String s) {
        this.textFieldWidget.m_94144_(String.valueOf(s));
    }

    protected String stripAddText(String s) {
        return s;
    }

    protected void textFieldPreRender(EditBox widget) {
    }

    @Override
    public void updateSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Override
    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.resetButton.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && !this.isMatchDefault(this.textFieldWidget.m_94155_());
        this.resetButton.f_93621_ = y;
        this.textFieldWidget.m_94186_(this.isEditable());
        this.textFieldWidget.f_93621_ = y + 1;
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.m_91087_().f_91062_.m_92718_()) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)(window.m_85445_() - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayedFieldName)), (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.f_93620_ = x;
            this.textFieldWidget.f_93620_ = x + this.resetButton.m_5711_();
        } else {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.f_93620_ = x + entryWidth - this.resetButton.m_5711_();
            this.textFieldWidget.f_93620_ = x + entryWidth - 148;
        }
        TextFieldListEntry.setTextFieldWidth(this.textFieldWidget, 148 - this.resetButton.m_5711_() - 4);
        this.resetButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.textFieldWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    protected abstract boolean isMatchDefault(String var1);

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }
}

