/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.apache.commons.lang3.StringUtils;

public class LocationModule
extends BaseModule {
    public LocationModule() {
        this.defaultNameColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_GREEN);
        this.defaultValueColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("dimension"));
        this.lines.add(new DebugLine("facing"));
        this.lines.add(new DebugLine("rotation"));
        this.lines.add(new DebugLine("light"));
        this.lines.add(new DebugLine("light_server"));
        this.lines.add(new DebugLine("highest_block"));
        this.lines.add(new DebugLine("highest_block_server"));
        this.lines.add(new DebugLine("biome"));
        this.lines.add(new DebugLine("local_difficulty"));
        this.lines.add(new DebugLine("days_played"));
        this.lines.add(new DebugLine("slime_chunk"));
    }

    @Override
    public void update(Minecraft client) {
        Entity cameraEntity = client.m_91288_();
        IntegratedServer integratedServer = client.m_91092_();
        String chunkLightString = "";
        String chunkLightServerString = "";
        String localDifficultyString = "";
        String slimeChunkString = "";
        StringBuilder highestBlock = new StringBuilder();
        StringBuilder highestBlockServer = new StringBuilder();
        if (client.f_91073_ != null) {
            ClientLevel serverWorld;
            assert (cameraEntity != null);
            BlockPos blockPos = cameraEntity.m_20183_();
            ChunkPos chunkPos = new ChunkPos(blockPos);
            ((DebugLine)this.lines.get(7)).value(client.f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)client.f_91073_.m_204166_(blockPos).m_203334_())));
            Object object = serverWorld = integratedServer != null ? integratedServer.m_129880_(client.f_91073_.m_46472_()) : client.f_91073_;
            if (client.f_91073_.m_7232_(blockPos.m_123341_(), blockPos.m_123343_())) {
                LevelChunk clientChunk = client.f_91073_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                if (clientChunk.m_6430_()) {
                    chunkLightString = I18n.m_118938_((String)"text.betterf3.line.waiting_chunk", (Object[])new Object[0]);
                } else if (serverWorld != null) {
                    LevelChunk serverChunk;
                    int totalLight = client.f_91073_.m_7726_().m_7827_().m_75831_(blockPos, 0);
                    int skyLight = client.f_91073_.m_45517_(LightLayer.SKY, blockPos);
                    int blockLight = client.f_91073_.m_45517_(LightLayer.BLOCK, blockPos);
                    chunkLightString = I18n.m_118938_((String)"format.betterf3.chunklight", (Object[])new Object[]{totalLight, skyLight, blockLight});
                    LevelLightEngine lightingProvider = serverWorld.m_7726_().m_7827_();
                    int skyLightServer = lightingProvider.m_75814_(LightLayer.SKY).m_7768_(blockPos);
                    int blockLightServer = lightingProvider.m_75814_(LightLayer.BLOCK).m_7768_(blockPos);
                    chunkLightServerString = I18n.m_118938_((String)"format.betterf3.chunklight_server", (Object[])new Object[]{skyLightServer, blockLightServer});
                    Heightmap.Types[] heightmapTypes = Heightmap.Types.values();
                    if (serverWorld instanceof ServerLevel) {
                        CompletionStage chunkCompletableFuture = ((ServerLevel)serverWorld).m_7726_().m_8431_(blockPos.m_123341_(), blockPos.m_123343_(), ChunkStatus.f_62326_, false).thenApply(either -> (LevelChunk)either.map(chunk -> (LevelChunk)chunk, unloaded -> null));
                        serverChunk = ((CompletableFuture)chunkCompletableFuture).getNow(null);
                    } else {
                        serverChunk = clientChunk;
                    }
                    for (Heightmap.Types type : heightmapTypes) {
                        int blockY;
                        String typeString;
                        if (type.m_64297_()) {
                            typeString = StringUtils.capitalize((String)type.m_64294_().replace("_", " "));
                            blockY = clientChunk.m_5885_(type, blockPos.m_123341_(), blockPos.m_123343_());
                            if (blockY > -1) {
                                highestBlock.append("  ").append(typeString).append(": ").append(blockY);
                            }
                        }
                        if (!type.m_64298_() || !(serverWorld instanceof ServerLevel)) continue;
                        if (serverChunk == null) {
                            serverChunk = clientChunk;
                        }
                        typeString = Utils.enumToString(type);
                        blockY = serverChunk.m_5885_(type, blockPos.m_123341_(), blockPos.m_123343_());
                        if (blockY <= -1) continue;
                        highestBlockServer.append("  ").append(typeString).append(": ").append(blockY);
                    }
                    if (blockPos.m_123342_() >= 0 && blockPos.m_123342_() < 256) {
                        float moonSize = serverWorld.m_46940_();
                        long inhabitedTime = Objects.requireNonNullElse(serverChunk, clientChunk).m_6319_();
                        DifficultyInstance localDifficulty = new DifficultyInstance(serverWorld.m_46791_(), serverWorld.m_46468_(), inhabitedTime, moonSize);
                        localDifficultyString = String.format("%.2f  " + I18n.m_118938_((String)"text.betterf3.line.clamped", (Object[])new Object[0]) + ": %.2f", Float.valueOf(localDifficulty.m_19056_()), Float.valueOf(localDifficulty.m_19057_()));
                    }
                    if (integratedServer != null) {
                        RandomSource slimeChunk = WorldgenRandom.m_224681_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)((WorldGenLevel)serverWorld).m_7328_(), (long)987234911L);
                        slimeChunkString = String.format("%s", I18n.m_118938_((String)(slimeChunk.m_188503_(10) == 0 ? "text.betterf3.line.slime_chunk.true" : "text.betterf3.line.slime_chunk.false"), (Object[])new Object[0]));
                    } else {
                        slimeChunkString = String.format("%s", I18n.m_118938_((String)"text.betterf3.line.slime_chunk.unknown", (Object[])new Object[0]));
                    }
                }
            }
        }
        if (client.f_91073_ != null) {
            ((DebugLine)this.lines.get(0)).value(client.f_91073_.m_46472_().m_135782_());
        }
        if (cameraEntity != null) {
            Direction facing = cameraEntity.m_6350_();
            String facingString = Utils.facingString(facing);
            ((DebugLine)this.lines.get(1)).value(String.format("%s (%s)", I18n.m_118938_((String)("text.betterf3.line." + facing.toString().toLowerCase()), (Object[])new Object[0]), facingString));
            String yaw = String.format("%.1f", Float.valueOf(Mth.m_14177_((float)cameraEntity.m_146908_())));
            String pitch = String.format("%.1f", Float.valueOf(Mth.m_14177_((float)cameraEntity.m_146909_())));
            ((DebugLine)this.lines.get(2)).value(I18n.m_118938_((String)"format.betterf3.rotation", (Object[])new Object[]{yaw, pitch}));
        }
        ((DebugLine)this.lines.get(3)).value(chunkLightString);
        ((DebugLine)this.lines.get(4)).value(chunkLightServerString);
        ((DebugLine)this.lines.get(5)).value(highestBlock.toString().trim());
        ((DebugLine)this.lines.get(6)).value(highestBlockServer.toString().trim());
        ((DebugLine)this.lines.get(8)).value(localDifficultyString);
        ((DebugLine)this.lines.get(9)).value(client.f_91073_.m_46468_() / 24000L);
        ((DebugLine)this.lines.get(10)).value(slimeChunkString.trim());
    }
}

