/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.util;

import com.fuzs.airhop.capability.CapabilityController;
import com.fuzs.airhop.capability.container.IAirHops;
import com.fuzs.airhop.config.ConfigHandler;
import com.fuzs.airhop.handler.CapabilityHandler;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class JumpHelper {
    public static boolean doJump(EntityPlayer player, boolean sneaking) {
        if (!JumpHelper.allowJump(player, sneaking)) {
            return false;
        }
        IAirHops capability = CapabilityController.getCapability((ICapabilityProvider)player, CapabilityController.AIR_HOPS_CAPABILITY);
        if (capability.getAirHops() < JumpHelper.possibleJumps(player)) {
            player.func_70664_aZ();
            capability.addAirHop();
            JumpHelper.setFallDistance(player);
            JumpHelper.addExtraExhaustion(player);
            return true;
        }
        return false;
    }

    private static boolean allowJump(EntityPlayer player, boolean sneaking) {
        boolean fallFlyingReady;
        boolean isInsideLiquid;
        boolean isPerformingAction = player.field_70122_E || player.func_184218_aH() || player.field_71075_bZ.field_75100_b;
        boolean bl = isInsideLiquid = player.func_70090_H() || player.func_180799_ab();
        if (isPerformingAction || isInsideLiquid) {
            return false;
        }
        ItemStack itemstack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        boolean bl2 = fallFlyingReady = !player.func_184613_cA() && itemstack.func_77973_b() == Items.field_185160_cR && ItemElytra.func_185069_d((ItemStack)itemstack);
        if (ConfigHandler.invertElytra) {
            boolean bl3 = sneaking = !sneaking;
        }
        if (fallFlyingReady && !sneaking) {
            return false;
        }
        return player.field_71075_bZ.field_75101_c || !ConfigHandler.f1BlockOnHungry || player.func_71024_bL().func_75116_a() > ConfigHandler.foodThreshold;
    }

    private static int possibleJumps(EntityPlayer player) {
        int level;
        EntityEquipmentSlot slot = ConfigHandler.enchantmentConfig.type.getSlot();
        if (slot == null) {
            level = JumpHelper.countLevels((List<ItemStack>)player.field_71071_by.field_70460_b);
        } else {
            ItemStack stack = player.func_184582_a(slot);
            level = EnchantmentHelper.func_77506_a((Enchantment)CapabilityHandler.AIR_HOP_ENCHANTMENT, (ItemStack)stack);
        }
        return level;
    }

    private static int countLevels(List<ItemStack> list) {
        int maxLevel = ConfigHandler.enchantmentConfig.maxLevel;
        return list.stream().mapToInt(itemStack -> Math.min(maxLevel, EnchantmentHelper.func_77506_a((Enchantment)CapabilityHandler.AIR_HOP_ENCHANTMENT, (ItemStack)itemStack))).sum();
    }

    private static void setFallDistance(EntityPlayer player) {
        float fallDistanceFactor = -1.25f;
        IAirHops capability = CapabilityController.getCapability((ICapabilityProvider)player, CapabilityController.AIR_HOPS_CAPABILITY);
        player.field_70143_R = ConfigHandler.resetFallDistance ? fallDistanceFactor * (float)capability.getAirHops() : (player.field_70143_R += fallDistanceFactor);
    }

    private static void addExtraExhaustion(EntityPlayer player) {
        float exhaustion = (float)Math.max(ConfigHandler.hopExhaustion - 1.0, 0.0);
        player.func_71020_j(player.func_70051_ag() ? 0.2f * exhaustion : 0.05f * exhaustion);
    }
}

