/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.handler;

import com.fuzs.airhop.capability.CapabilityController;
import com.fuzs.airhop.config.ConfigHandler;
import com.fuzs.airhop.enchantment.EnchantmentAirHop;
import com.fuzs.airhop.network.NetworkHandler;
import com.fuzs.airhop.network.messages.MessageSyncAirJump;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CapabilityHandler {
    @GameRegistry.ObjectHolder(value="airhop:air_hop")
    public static final Enchantment AIR_HOP_ENCHANTMENT = null;

    @SubscribeEvent
    public void onRegisterEnchantment(RegistryEvent.Register<Enchantment> evt) {
        EntityEquipmentSlot[] armorSlots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
        EnchantmentAirHop entry = new EnchantmentAirHop(ConfigHandler.enchantmentConfig.rarity, ConfigHandler.enchantmentConfig.type, armorSlots);
        ((Enchantment)entry.setRegistryName(new ResourceLocation("airhop", "air_hop"))).func_77322_b("air_hop");
        evt.getRegistry().register((IForgeRegistryEntry)entry);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.player.field_70122_E) {
            CapabilityController.getCapability((ICapabilityProvider)evt.player, CapabilityController.AIR_HOPS_CAPABILITY).resetAirHops();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        EntityPlayerMP player;
        int airHops;
        if (evt.getEntity() instanceof EntityPlayerMP && (airHops = CapabilityController.getCapability((ICapabilityProvider)(player = (EntityPlayerMP)evt.getEntity()), CapabilityController.AIR_HOPS_CAPABILITY).getAirHops()) > 0) {
            NetworkHandler.sendTo(new MessageSyncAirJump(airHops), player);
        }
    }
}

