/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.woolbuttons;

import bl4ckscor3.mod.woolbuttons.BlockWoolButton;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="sbmwoolbuttons", name="Wool Buttons", version="v1.1", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class WoolButtons {
    public static final String MODID = "sbmwoolbuttons";
    public static final String VERSION = "v1.1";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata modMeta = event.getModMetadata();
        modMeta.authorList = Arrays.asList("bl4ckscor3", "DarkGuardsman");
        modMeta.autogenerated = false;
        modMeta.version = VERSION;
        modMeta.description = "Simple wool versions of the vanilla buttons. Contains option to enable/disable sound.";
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((Block)new BlockWoolButton().setRegistryName(WoolButtons.getName(color))).func_149663_c("sbmwoolbuttons:wool.button." + color.name().toLowerCase()));
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(WoolButtons.getName(color));
            if (block == null) continue;
            event.getRegistry().register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
    }

    public static ResourceLocation getName(EnumDyeColor color) {
        return new ResourceLocation(MODID, "wool_button_" + color.name().toLowerCase());
    }
}

