/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;

public class RenderUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final FontRenderer font = RenderUtils.mc.field_71466_p;

    public static List<String> trimStringToWidth(String str, int maxWidth) {
        ArrayList<String> trimmedStrings = new ArrayList<String>();
        for (ITextProperties text : font.func_238420_b_().func_238365_g_(str, maxWidth, Style.field_240709_b_)) {
            trimmedStrings.add(text.getString());
        }
        return trimmedStrings;
    }

    public static void renderSplitString(MatrixStack stack, String string, int x, int y, int wrapWidth, int color) {
        for (String s : RenderUtils.trimStringToWidth(string, wrapWidth)) {
            font.func_238405_a_(stack, s, (float)x, (float)y, color);
            font.getClass();
            y += 9;
        }
    }

    public static int getSplitStringWidth(String string, int wrapWidth) {
        List<String> lines = RenderUtils.trimStringToWidth(string, wrapWidth);
        int width = 0;
        for (String line : lines) {
            int stringWidth = font.func_78256_a(line);
            if (stringWidth <= width) continue;
            width = stringWidth;
        }
        return width;
    }

    public static int getSplitStringHeight(String string, int wrapWidth) {
        font.getClass();
        return 9 * RenderUtils.trimStringToWidth(string, wrapWidth).size();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        int temp;
        if (left < right) {
            temp = left;
            left = right;
            right = temp;
        }
        if (top < bottom) {
            temp = top;
            top = bottom;
            bottom = temp;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)left, (double)bottom, 0.0).func_181675_d();
        buffer.func_225582_a_((double)right, (double)bottom, 0.0).func_181675_d();
        buffer.func_225582_a_((double)right, (double)top, 0.0).func_181675_d();
        buffer.func_225582_a_((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static int getRenderWidth(String position, int width) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("center_left") || positionLower.equals("bottom_left")) {
            return 10;
        }
        return mc.func_228018_at_().func_198107_o() - width;
    }

    public static int getRenderHeight(String position, int height) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("top_right")) {
            return 5;
        }
        if (positionLower.equals("bottom_left") || positionLower.equals("bottom_right")) {
            return mc.func_228018_at_().func_198087_p() - height - 5;
        }
        return mc.func_228018_at_().func_198087_p() / 2 - height / 2;
    }
}

