/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.note;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.note.Scope;
import com.chaosthedude.notes.util.FileUtils;
import com.chaosthedude.notes.util.RenderUtils;
import com.chaosthedude.notes.util.StringUtils;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SharedConstants;

public class Note {
    private static final DateFormat dateFormat = new SimpleDateFormat((String)ConfigHandler.CLIENT.dateFormat.get());
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final FontRenderer fontRenderer = Note.mc.field_71466_p;
    private String title;
    private String rawText;
    private Scope scope;
    private File prevSaveFile;
    private File saveFile;
    private File saveDir;

    public Note(String title, String text, Scope scope) {
        this.title = title;
        this.rawText = text;
        this.scope = scope;
        this.updateSaveFile();
        this.prevSaveFile = this.saveFile;
    }

    public Note(File file) {
        this.update(file);
    }

    public Note setTitle(String newTitle) {
        this.title = newTitle;
        this.updateSaveFile();
        return this;
    }

    public Note setText(String text) {
        this.rawText = text;
        return this;
    }

    public Note setScope(Scope newScope) {
        this.scope = newScope;
        this.updateSaveFile();
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRawText() {
        return this.rawText;
    }

    public String getFilteredText() {
        return StringUtils.filter(this.rawText);
    }

    public File getPrevSaveFile() {
        return this.prevSaveFile;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void updateSaveFile() {
        this.updateSaveDir();
        this.saveFile = new File(this.saveDir, this.getSaveName());
    }

    public void updateSaveDir() {
        if (this.scope != null) {
            this.saveDir = this.scope.getCurrentSaveDirectory();
        } else {
            this.catchNullScope();
        }
    }

    public String getPreview(int width) {
        String preview = this.rawText;
        boolean addEllipsis = false;
        if (fontRenderer.func_78256_a(preview) > width || RenderUtils.trimStringToWidth(preview, width).size() > 1) {
            preview = RenderUtils.trimStringToWidth(preview, width).get(0);
            addEllipsis = true;
        }
        for (char c : StringUtils.FILTER_CHARS) {
            if (!preview.contains(String.valueOf(c))) continue;
            preview = preview.substring(0, preview.indexOf(String.valueOf(c)));
        }
        if (preview.indexOf(10) >= 0) {
            preview = preview.substring(0, preview.indexOf(10));
        }
        if (addEllipsis) {
            preview = preview + "...";
        }
        return preview;
    }

    public long getLastModified() {
        return this.saveFile.lastModified();
    }

    public String getLastModifiedString() {
        return I18n.func_135052_a((String)"notes.lastModified", (Object[])new Object[0]) + ": " + dateFormat.format(this.getLastModified());
    }

    public String getUncollidingSaveName(String name) {
        File file = new File(this.saveDir, this.addFileExtension(name = name.replaceAll("[\\./\"]", "_")));
        if (!file.equals(this.prevSaveFile)) {
            while (file.exists()) {
                name = name + "-";
                file = new File(this.saveDir, this.addFileExtension(name));
            }
        }
        return name;
    }

    public String getSaveName() {
        String saveDirName = this.title.trim();
        for (char c : SharedConstants.field_71567_b) {
            saveDirName = saveDirName.replace(c, '_');
        }
        if (saveDirName == null || saveDirName.isEmpty()) {
            saveDirName = "New Note";
        }
        return this.addFileExtension(this.getUncollidingSaveName(saveDirName));
    }

    public String addFileExtension(String name) {
        return name + ".txt";
    }

    public void save() {
        BufferedWriter writer = null;
        try {
            this.prevSaveFile.delete();
            if (!this.saveFile.getParentFile().exists()) {
                this.saveFile.getParentFile().mkdirs();
            }
            writer = new BufferedWriter(new FileWriter(this.saveFile));
            writer.write(this.rawText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean tryOpenExternal() {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().edit(this.getSaveFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void copy() {
        Note copy = new Note(this.title + " Copy", this.rawText, this.scope);
        copy.save();
    }

    public void delete() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
        }
        this.saveFile.delete();
    }

    public void catchNullScope() {
        this.scope = Scope.GLOBAL;
        this.saveDir = this.scope.getCurrentSaveDirectory();
        Notes.logger.error("No scope found for the following note:" + this.getTitle() + ". Setting scope to Global.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(File file) {
        this.title = FileUtils.getFileName(file);
        this.scope = Scope.getScopeFromParentFile(file.getParentFile());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                builder.append(System.lineSeparator());
                line = reader.readLine();
            }
            this.rawText = builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.saveFile = file;
        this.prevSaveFile = file;
    }

    public void update() {
        this.update(this.saveFile);
    }

    public boolean equals(Note note) {
        try {
            return note != null && note.getSaveFile() != null && this.saveFile.getCanonicalPath().equals(note.getSaveFile().getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isPinned() {
        return this.equals(Notes.pinnedNote);
    }

    public boolean isValidScope() {
        return this.scope == Scope.getCurrentScope() || this.scope == Scope.GLOBAL;
    }

    public static List<Note> getCurrentNotes() {
        ArrayList<Note> notes = new ArrayList<Note>();
        if (Scope.currentScopeIsValid()) {
            for (File file : Scope.getCurrentScope().getCurrentSaveDirectory().listFiles()) {
                if (!FileUtils.isNote(file)) continue;
                notes.add(new Note(file));
            }
        }
        for (File file : Scope.GLOBAL.getCurrentSaveDirectory().listFiles()) {
            if (!FileUtils.isNote(file)) continue;
            notes.add(new Note(file));
        }
        Collections.sort(notes, Collections.reverseOrder(new Comparator<Note>(){

            @Override
            public int compare(Note n1, Note n2) {
                return Long.compare(n1.getLastModified(), n2.getLastModified());
            }
        }));
        return notes;
    }
}

