/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.NotesListEntry;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectNoteScreen
extends Screen {
    private Screen prevScreen;
    private NotesButton newButton;
    private NotesButton selectButton;
    private NotesButton editButton;
    private NotesButton copyButton;
    private NotesButton deleteButton;
    private NotesButton pinButton;
    private NotesButton cancelButton;
    private NotesList selectionList;

    public SelectNoteScreen(Screen prevScreen) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"notes.selectNote", (Object[])new Object[0])));
        this.prevScreen = prevScreen;
    }

    public void func_231160_c_() {
        this.setupButtons();
        this.selectionList = new NotesList(this, this.field_230706_i_, this.field_230708_k_ + 110, this.field_230709_l_, 40, this.field_230709_l_ - 64, 36);
        this.field_230705_e_.add(this.selectionList);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.selectionList.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        SelectNoteScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"notes.selectNote", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 + 60), (int)15, (int)0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        if (this.selectionList.func_230958_g_() != null) {
            this.pinButton.func_238482_a_((ITextComponent)(((NotesListEntry)this.selectionList.func_230958_g_()).isPinned() ? new TranslationTextComponent("notes.unpin") : new TranslationTextComponent("notes.pin")));
        }
    }

    public void selectNote(NotesListEntry entry) {
        boolean enable;
        this.selectButton.field_230693_o_ = enable = entry != null;
        this.deleteButton.field_230693_o_ = enable;
        this.editButton.field_230693_o_ = enable;
        this.copyButton.field_230693_o_ = enable;
        this.pinButton.field_230693_o_ = enable;
    }

    private void setupButtons() {
        this.newButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 40, 110, 20, (ITextComponent)new TranslationTextComponent("notes.new"), onPress -> this.field_230706_i_.func_147108_a((Screen)new EditNoteScreen(this, null))));
        this.selectButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 65, 110, 20, (ITextComponent)new TranslationTextComponent("notes.select"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.func_230958_g_();
            if (notesEntry != null) {
                notesEntry.loadNote();
            }
        }));
        this.editButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 90, 110, 20, (ITextComponent)new TranslationTextComponent("notes.edit"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.func_230958_g_();
            if (notesEntry != null) {
                notesEntry.editNote();
            }
        }));
        this.copyButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 115, 110, 20, (ITextComponent)new TranslationTextComponent("notes.copy"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.func_230958_g_();
            notesEntry.copyNote();
        }));
        this.deleteButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 140, 110, 20, (ITextComponent)new TranslationTextComponent("notes.delete"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.func_230958_g_();
            if (notesEntry != null) {
                notesEntry.deleteNote();
            }
        }));
        this.pinButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 165, 110, 20, (ITextComponent)new TranslationTextComponent("notes.pin"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.func_230958_g_();
            notesEntry.togglePin();
        }));
        this.cancelButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, this.field_230709_l_ - 30, 110, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), onPress -> this.field_230706_i_.func_147108_a(this.prevScreen)));
        this.selectButton.field_230693_o_ = false;
        this.deleteButton.field_230693_o_ = false;
        this.editButton.field_230693_o_ = false;
        this.copyButton.field_230693_o_ = false;
        this.pinButton.field_230693_o_ = false;
    }
}

