/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesConfirmScreen;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.SelectNoteScreen;
import com.chaosthedude.notes.note.Note;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NotesListEntry
extends ExtendedList.AbstractListEntry<NotesListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private final Minecraft mc;
    private final SelectNoteScreen guiNotes;
    private final Note note;
    private final NotesList notesList;
    private long lastClickTime;

    public NotesListEntry(NotesList notesList, Note note) {
        this.notesList = notesList;
        this.note = note;
        this.guiNotes = notesList.getGuiNotes();
        this.mc = Minecraft.func_71410_x();
    }

    public void func_230432_a_(MatrixStack stack, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        this.mc.field_71466_p.func_238421_b_(stack, this.note.getTitle(), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        this.mc.field_71466_p.func_238421_b_(stack, this.note.getScope().format(), (float)(par3 + 4 + this.mc.field_71466_p.func_78256_a(this.note.getTitle())), (float)(par2 + 1), 0x808080);
        if (this.note.isPinned()) {
            this.mc.field_71466_p.func_238421_b_(stack, I18n.func_135052_a((String)"notes.pinned", (Object[])new Object[0]), (float)(par3 + 4 + this.mc.field_71466_p.func_78256_a(this.note.getTitle()) + this.mc.field_71466_p.func_78256_a(this.note.getScope().format()) + 4), (float)(par2 + 1), 0xFFFFFF);
        }
        this.mc.field_71466_p.func_238421_b_(stack, this.note.getTitle(), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        String string = this.note.getPreview(MathHelper.func_76128_c((double)((double)this.notesList.func_230949_c_() * 0.9)));
        float f = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer.func_238421_b_(stack, string, f, (float)(par2 + 9 + 3), 0x808080);
        FontRenderer fontRenderer2 = this.mc.field_71466_p;
        String string2 = this.note.getLastModifiedString();
        float f2 = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer2.func_238421_b_(stack, string2, f2, (float)(par2 + 9 + 14), 0x808080);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int button) {
        if (button == 0) {
            this.notesList.selectNote(this);
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.loadNote();
                return true;
            }
            this.lastClickTime = Util.func_211177_b();
        }
        return false;
    }

    public void editNote() {
        if (((Boolean)ConfigHandler.CLIENT.useInGameEditor.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.func_147108_a((Screen)new EditNoteScreen(this.guiNotes, this.note));
        }
    }

    public void copyNote() {
        this.note.copy();
        this.notesList.refreshList();
    }

    public void loadNote() {
        this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        if (((Boolean)ConfigHandler.CLIENT.useInGameViewer.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.func_147108_a((Screen)new DisplayNoteScreen(this.guiNotes, this.note));
        }
    }

    public void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
        } else {
            Notes.pinnedNote = this.note;
            this.mc.func_147108_a(null);
        }
    }

    public boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    public Note getNote() {
        return this.note;
    }

    public void deleteNote() {
        this.mc.func_147108_a((Screen)new NotesConfirmScreen(result -> {
            if (result) {
                this.note.delete();
            }
            this.mc.func_147108_a((Screen)this.guiNotes);
        }, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"notes.confirmDelete", (Object[])new Object[0])), (ITextComponent)new StringTextComponent(this.note.getTitle())));
    }
}

