/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesTextField;
import com.chaosthedude.notes.gui.NotesTitleField;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.note.Scope;
import com.chaosthedude.notes.util.StringUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditNoteScreen
extends Screen {
    private final Screen parentScreen;
    private NotesButton saveButton;
    private NotesButton globalButton;
    private NotesButton insertBiomeButton;
    private NotesButton insertChunkButton;
    private NotesButton insertCoordsButton;
    private NotesButton cancelButton;
    private NotesTitleField noteTitleField;
    private NotesTextField noteTextField;
    private String saveDirName;
    private Note note;
    private Scope scope;
    private boolean pinned;

    public EditNoteScreen(Screen parentScreen, @Nullable Note note) {
        super((ITextComponent)new StringTextComponent(note != null ? I18n.func_135052_a((String)"notes.editNote", (Object[])new Object[0]) : I18n.func_135052_a((String)"notes.newNote", (Object[])new Object[0])));
        this.parentScreen = parentScreen;
        this.note = note != null ? note : new Note("New Note", "", Scope.getCurrentScope());
        this.scope = Scope.getCurrentScope();
        this.pinned = this.note.isPinned();
    }

    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.setupTextFields();
        this.setupButtons();
    }

    public void func_231023_e_() {
        this.noteTitleField.func_146178_a();
        this.noteTextField.func_231023_e_();
        this.insertChunkButton.field_230693_o_ = this.insertCoordsButton.field_230693_o_ = this.noteTextField.isFocused();
        this.insertBiomeButton.field_230693_o_ = this.insertCoordsButton.field_230693_o_;
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public boolean func_231046_a_(int keyCode, int par2, int par3) {
        super.func_231046_a_(keyCode, par2, par3);
        if (keyCode == 256) {
            this.field_230706_i_.func_147108_a(this.parentScreen);
            return true;
        }
        if (keyCode == 258 && this.noteTitleField.func_230999_j_()) {
            this.noteTitleField.func_230996_d_(false);
            this.noteTextField.setFocused(true);
            return true;
        }
        this.updateNote();
        return false;
    }

    public boolean func_223281_a_(int keyCode, int par2, int par3) {
        this.updateNote();
        return super.func_223281_a_(keyCode, par2, par3);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean ret = false;
        for (IGuiEventListener listener : this.func_231039_at__()) {
            if (!listener.func_231044_a_(mouseX, mouseY, button)) continue;
            this.func_231035_a_(listener);
            if (button == 0) {
                this.func_231037_b__(true);
            }
            ret = true;
        }
        return ret;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        EditNoteScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2 + 60), (int)15, (int)0xFFFFFF);
        this.noteTitleField.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.noteTextField.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        EditNoteScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"notes.saveAs", (Object[])new Object[]{this.note.getUncollidingSaveName(this.note.getTitle())}), (int)(this.field_230708_k_ / 2 + 55), (int)65, (int)0x808080);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    private void setupButtons() {
        this.saveButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 40, 110, 20, (ITextComponent)new TranslationTextComponent("notes.save"), onPress -> {
            this.updateNote();
            this.note.save();
            this.field_230706_i_.func_147108_a((Screen)new DisplayNoteScreen(this.parentScreen, this.note));
            if (this.pinned) {
                Notes.pinnedNote = this.note;
            }
        }));
        this.globalButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 65, 110, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"notes.global", (Object[])new Object[0]) + ": " + (this.note.getScope() == Scope.GLOBAL ? I18n.func_135052_a((String)"notes.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"notes.off", (Object[])new Object[0]))), onPress -> {
            this.scope = this.scope == Scope.GLOBAL ? Scope.getCurrentScope() : Scope.GLOBAL;
            this.globalButton.func_238482_a_((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"notes.global", (Object[])new Object[0]) + (this.scope == Scope.GLOBAL ? ": " + I18n.func_135052_a((String)"notes.on", (Object[])new Object[0]) : ": " + I18n.func_135052_a((String)"notes.off", (Object[])new Object[0]))));
            this.updateNote();
        }));
        this.insertBiomeButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 90, 110, 20, (ITextComponent)new TranslationTextComponent("notes.biome"), onPress -> this.insertBiome()));
        this.insertChunkButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 115, 110, 20, (ITextComponent)new TranslationTextComponent("notes.chunk"), onPress -> this.insertChunk()));
        this.insertCoordsButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 140, 110, 20, (ITextComponent)new TranslationTextComponent("notes.coordinates"), onPress -> this.insertCoords()));
        this.cancelButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, this.field_230709_l_ - 30, 110, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), onPress -> this.field_230706_i_.func_147108_a(this.parentScreen)));
        this.insertBiomeButton.field_230693_o_ = false;
        this.insertChunkButton.field_230693_o_ = false;
        this.insertCoordsButton.field_230693_o_ = false;
    }

    private void setupTextFields() {
        this.noteTitleField = new NotesTitleField(this.field_230712_o_, 130, 40, this.field_230708_k_ - 140, 20, (ITextComponent)new StringTextComponent(""));
        this.noteTitleField.func_146180_a(this.note.getTitle());
        this.field_230705_e_.add(this.noteTitleField);
        this.noteTitleField.func_231049_c__(true);
        this.noteTitleField.func_230996_d_(true);
        this.func_231035_a_((IGuiEventListener)this.noteTitleField);
        this.noteTextField = new NotesTextField(this.field_230712_o_, 130, 85, this.field_230708_k_ - 140, this.field_230709_l_ - 95, 5);
        this.noteTextField.setText(this.note.getFilteredText());
        this.field_230705_e_.add(this.noteTextField);
    }

    private void updateNote() {
        this.note.setTitle(this.noteTitleField.func_146179_b());
        this.note.setText(this.noteTextField.getText());
        this.note.setScope(this.scope);
    }

    private void insertBiome() {
        this.noteTextField.insert(StringUtils.fixBiomeName((World)this.field_230706_i_.field_71441_e, this.field_230706_i_.field_71441_e.func_226691_t_(this.field_230706_i_.field_71439_g.func_233580_cy_())));
    }

    private void insertChunk() {
        this.noteTextField.insert(this.field_230706_i_.field_71439_g.field_70176_ah + ", " + this.field_230706_i_.field_71439_g.field_70162_ai + ", " + this.field_230706_i_.field_71439_g.field_70164_aj);
    }

    private void insertCoords() {
        this.noteTextField.insert((int)this.field_230706_i_.field_71439_g.func_226277_ct_() + ", " + (int)this.field_230706_i_.field_71439_g.func_226278_cu_() + ", " + (int)this.field_230706_i_.field_71439_g.func_226281_cx_());
    }
}

