/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesConfirmScreen;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.util.RenderUtils;
import com.chaosthedude.notes.util.StringUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DisplayNoteScreen
extends Screen {
    private final Screen parentScreen;
    private NotesButton doneButton;
    private NotesButton pinButton;
    private NotesButton editButton;
    private NotesButton deleteButton;
    private NotesButton prevButton;
    private NotesButton nextButton;
    private Note note;
    private int page;
    private List<String> pages;

    public DisplayNoteScreen(Screen parentScreen, Note note) {
        super((ITextComponent)new StringTextComponent(note.getTitle()));
        this.parentScreen = parentScreen;
        this.note = note;
        this.page = 0;
        this.pages = new ArrayList<String>();
        this.pages.add("");
    }

    public void func_231160_c_() {
        this.setupButtons();
        this.setupPages();
    }

    public void func_231023_e_() {
        this.prevButton.field_230693_o_ = this.page > 0;
        this.nextButton.field_230693_o_ = this.page < this.pages.size() - 1;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        DisplayNoteScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2 + 60), (int)15, (int)-1);
        this.displayNote(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void displayNote(MatrixStack stack) {
        RenderUtils.renderSplitString(stack, this.pages.get(this.page), 160, 40, this.field_230708_k_ - 200, 0xFFFFFF);
    }

    private void setupButtons() {
        this.editButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 40, 110, 20, (ITextComponent)new TranslationTextComponent("notes.edit"), onPress -> this.field_230706_i_.func_147108_a((Screen)new EditNoteScreen(this.parentScreen, this.note))));
        this.deleteButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 65, 110, 20, (ITextComponent)new TranslationTextComponent("notes.delete"), onPress -> this.deleteNote()));
        this.pinButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, 90, 110, 20, (ITextComponent)(this.isPinned() ? new TranslationTextComponent("notes.unpin") : new TranslationTextComponent("notes.pin")), onPress -> {
            this.togglePin();
            if (this.isPinned()) {
                this.field_230706_i_.func_147108_a(null);
            }
        }));
        this.doneButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(10, this.field_230709_l_ - 30, 110, 20, (ITextComponent)new TranslationTextComponent("gui.done"), onPress -> this.field_230706_i_.func_147108_a(this.parentScreen)));
        this.prevButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(130, this.field_230709_l_ - 30, 20, 20, (ITextComponent)new TranslationTextComponent("<"), onPress -> {
            if (this.page > 0) {
                --this.page;
            }
        }));
        this.nextButton = (NotesButton)this.func_230480_a_((Widget)new NotesButton(this.field_230708_k_ - 30, this.field_230709_l_ - 30, 20, 20, (ITextComponent)new TranslationTextComponent(">"), onPress -> {
            if (this.page < this.pages.size() - 1) {
                ++this.page;
            }
        }));
    }

    private void setupPages() {
        if (this.note != null) {
            List<String> lines = (Boolean)ConfigHandler.CLIENT.wrapNote.get() != false ? RenderUtils.trimStringToWidth(this.note.getFilteredText(), this.field_230708_k_ - 200) : StringUtils.wrapToWidth(this.note.getFilteredText(), this.field_230708_k_ - 200);
            this.pages = new ArrayList<String>();
            int lineCount = 0;
            String page = "";
            for (String line : lines) {
                if (lineCount > 15) {
                    this.pages.add(page);
                    page = "";
                    lineCount = 0;
                }
                page = page + line + "\n";
                ++lineCount;
            }
            if (!page.isEmpty()) {
                this.pages.add(page);
            }
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
    }

    private boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    private void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
            this.pinButton.func_238482_a_((ITextComponent)new TranslationTextComponent("notes.pin"));
        } else {
            Notes.pinnedNote = this.note;
            this.pinButton.func_238482_a_((ITextComponent)new TranslationTextComponent("notes.unpin"));
        }
    }

    private void deleteNote() {
        this.field_230706_i_.func_147108_a((Screen)new NotesConfirmScreen(result -> {
            if (result) {
                this.note.delete();
            }
            this.field_230706_i_.func_147108_a(this.parentScreen);
        }, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"notes.confirmDelete", (Object[])new Object[0])), (ITextComponent)new StringTextComponent(this.note.getTitle())));
    }
}

