/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PlayerFunctions {
    public static boolean respawnPlayer(World world, PlayerEntity player) {
        if (!(player instanceof ServerPlayerEntity)) {
            return false;
        }
        MinecraftServer server = world.func_73046_m();
        ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
        if (serverplayer.field_71136_j) {
            serverplayer.field_71136_j = false;
            serverplayer = server.func_184103_al().func_232644_a_(serverplayer, true);
            CriteriaTriggers.field_193134_u.func_233551_a_(serverplayer, World.field_234920_i_, World.field_234918_g_);
        } else if (serverplayer.func_110143_aJ() <= 0.0f) {
            server.func_184103_al().func_232644_a_(serverplayer, false);
        }
        return true;
    }

    public static PlayerEntity matchPlayer(PlayerEntity player, String other) {
        return PlayerFunctions.matchPlayer(player.func_130014_f_(), other);
    }

    public static PlayerEntity matchPlayer(World world, String other) {
        List players = world.func_217369_A();
        for (PlayerEntity onlineplayer : players) {
            if (!onlineplayer.func_200200_C_().getString().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(PlayerEntity player) {
        return player.func_184586_b(Hand.OFF_HAND).func_77973_b().equals(Items.field_151131_as) || player.func_184586_b(Hand.MAIN_HAND).func_77973_b().equals(Items.field_151131_as);
    }

    public static boolean isJoiningWorldForTheFirstTime(PlayerEntity player, String modid) {
        String firstjointag = "collective.firstJoin." + modid;
        Set tags = player.func_184216_O();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.func_184211_a(firstjointag);
        PlayerInventory inv = player.field_71071_by;
        boolean isempty = true;
        for (int i = 0; i < 36; ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            isempty = false;
            break;
        }
        if (!isempty) {
            return false;
        }
        World world = player.func_130014_f_();
        ServerWorld serverworld = (ServerWorld)world;
        BlockPos wspos = serverworld.func_241135_u_();
        BlockPos ppos = player.func_233580_cy_();
        BlockPos cpos = new BlockPos(ppos.func_177958_n(), wspos.func_177956_o(), ppos.func_177952_p());
        return cpos.func_218141_a((Vector3i)wspos, 50.0);
    }

    public static BlockPos getSpawnPoint(World world, PlayerEntity player) {
        Vector3d spawnvec = PlayerFunctions.getSpawnVec(world, player);
        return new BlockPos(spawnvec.field_72450_a, spawnvec.field_72448_b, spawnvec.field_72449_c);
    }

    public static Vector3d getSpawnVec(World world, PlayerEntity player) {
        Optional optionalbed;
        ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
        ServerWorld serverworld = (ServerWorld)world;
        BlockPos respawnlocation = serverworld.func_241135_u_();
        Vector3d respawnvec = new Vector3d((double)respawnlocation.func_177958_n(), (double)respawnlocation.func_177956_o(), (double)respawnlocation.func_177952_p());
        BlockPos bedpos = serverplayer.func_241140_K_();
        if (bedpos != null && (optionalbed = PlayerEntity.func_242374_a((ServerWorld)serverworld, (BlockPos)bedpos, (float)1.0f, (boolean)false, (boolean)false)).isPresent()) {
            Vector3d bedvec = (Vector3d)optionalbed.get();
            BlockPos bp = new BlockPos(bedvec);
            Iterator it = BlockPos.func_218287_a((int)(bp.func_177958_n() - 1), (int)(bp.func_177956_o() - 1), (int)(bp.func_177952_p() - 1), (int)(bp.func_177958_n() + 1), (int)(bp.func_177956_o() + 1), (int)(bp.func_177952_p() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos np = (BlockPos)it.next();
                BlockState state = world.func_180495_p(np);
                Block block = state.func_177230_c();
                if (!(block instanceof BedBlock)) continue;
                respawnvec = bedvec;
                break;
            }
        }
        return respawnvec;
    }

    public static Hand getOtherHand(Hand hand) {
        if (hand.equals((Object)Hand.MAIN_HAND)) {
            return Hand.OFF_HAND;
        }
        return Hand.MAIN_HAND;
    }

    public static String getPlayerGearString(PlayerEntity player) {
        StringBuilder skconfig = new StringBuilder();
        ItemStack offhand = player.func_184582_a(EquipmentSlotType.OFFHAND);
        if (!offhand.func_190926_b()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt = offhand.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig.append("'offhand' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("'offhand' : '',");
        }
        ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
        if (!head.func_190926_b()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt = head.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig.append("\n'head' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'head' : '',");
        }
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        if (!chest.func_190926_b()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt = chest.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig.append("\n'chest' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'chest' : '',");
        }
        ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
        if (!legs.func_190926_b()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt = legs.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig.append("\n'legs' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'legs' : '',");
        }
        ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
        if (!feet.func_190926_b()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt = feet.func_77955_b(nbt);
            String nbtstring = nbt.toString();
            skconfig.append("\n'feet' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'feet' : '',");
        }
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (!slot.func_190926_b()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt = slot.func_77955_b(nbt);
                String nbtstring = nbt.toString();
                skconfig.append("\n").append(i).append(" : ").append("'").append(nbtstring).append("',");
                continue;
            }
            skconfig.append("\n").append(i).append(" : '',");
        }
        return skconfig.toString();
    }

    public static String getPlayerGearStringFromHashMap(HashMap<String, ItemStack> gear) {
        CompoundNBT nbt;
        StringBuilder gearstring = new StringBuilder();
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                nbt = new CompoundNBT();
                nbt = gear.get(specialslot).func_77955_b(nbt);
                specialslotstring = nbt.toString();
            }
            if (!gearstring.toString().equals("")) {
                gearstring.append("\n");
            }
            gearstring.append("'").append(specialslot).append("'").append(" : ").append("'").append(specialslotstring).append("',");
        }
        NonNullList emptyinventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                nbt = new CompoundNBT();
                nbt = gear.get("" + i).func_77955_b(nbt);
                itemstring = nbt.toString();
            }
            gearstring.append("\n").append(i).append(" : '").append(itemstring).append("',");
        }
        return gearstring.toString();
    }

    public static void setPlayerGearFromString(PlayerEntity player, String gearconfig) {
        String[] gearspl = gearconfig.split("',[\\r\\n]+");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            System.out.println("[Error] (Collective) setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        block18: for (String line : gearspl) {
            EquipmentSlotType type;
            String[] lspl;
            if ((line = line.trim()).endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            if (!line.endsWith("'")) {
                line = line + "'";
            }
            if ((lspl = line.split(" : ")).length != 2) {
                System.out.println("[Error] (Collective) setPlayerGearFromString: The line " + line + " is invalid.");
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if (data.startsWith("'")) {
                data = data.substring(1);
            }
            if (data.endsWith("'")) {
                data = data.substring(0, data.length() - 1);
            }
            if (data.length() < 2) continue;
            data = data.replaceAll("\r", "");
            ItemStack itemstack = null;
            try {
                CompoundNBT newnbt = JsonToNBT.func_180713_a((String)data);
                itemstack = ItemStack.func_199557_a((CompoundNBT)newnbt);
            }
            catch (CommandSyntaxException e0) {
                try {
                    data = data.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
                    CompoundNBT newnbt = JsonToNBT.func_180713_a((String)data);
                    itemstack = ItemStack.func_199557_a((CompoundNBT)newnbt);
                }
                catch (CommandSyntaxException e1) {
                    System.out.println((Object)e1);
                }
            }
            if (itemstack == null) {
                System.out.println("[Error] (Collective) setPlayerGearFromString: Unable to get the correct itemstack data from data " + data);
                return;
            }
            if (!cleared) {
                cleared = true;
                player.field_71071_by.func_174888_l();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.field_71071_by.func_70299_a(slot, itemstack);
                continue;
            }
            switch (slotstring) {
                case "offhand": {
                    type = EquipmentSlotType.OFFHAND;
                    break;
                }
                case "head": {
                    type = EquipmentSlotType.HEAD;
                    break;
                }
                case "chest": {
                    type = EquipmentSlotType.CHEST;
                    break;
                }
                case "legs": {
                    type = EquipmentSlotType.LEGS;
                    break;
                }
                case "feet": {
                    type = EquipmentSlotType.FEET;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            if (type == null) continue;
            player.func_184201_a(type, itemstack);
        }
    }
}

