/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.firespreadtweaks.events;

import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.firespreadtweaks.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FireSpreadEvent {
    private static HashMap<BlockPos, Integer> ticksleft = new HashMap();
    private static HashMap<World, CopyOnWriteArrayList<BlockPos>> firepositions = new HashMap();
    private static List<Block> fireblocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150424_aL, Blocks.field_196814_hQ, Blocks.field_150425_aM, Blocks.field_235336_cN_));

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        if (!firepositions.containsKey(world)) {
            firepositions.put(world, new CopyOnWriteArrayList());
            return;
        }
        for (BlockPos firepos : firepositions.get(world)) {
            if (!ticksleft.containsKey(firepos)) {
                ticksleft.put(firepos, Util.getFireBurnDurationInTicks());
                continue;
            }
            int tl = ticksleft.get(firepos) - 1;
            if (tl <= 0) {
                ticksleft.remove(firepos);
                firepositions.get(world).remove(firepos);
                BlockState firestate = world.func_180495_p(firepos);
                Block fireblock = firestate.func_177230_c();
                if (!(fireblock instanceof FireBlock)) continue;
                world.func_175656_a(firepos, Blocks.field_150350_a.func_176223_P());
                continue;
            }
            ticksleft.put(firepos, tl);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        GameRules.BooleanValue firetickvalue = (GameRules.BooleanValue)world.func_82736_K().func_223585_a(GameRules.field_223598_a);
        if (firetickvalue.func_223572_a()) {
            firetickvalue.func_223570_a(false, world.func_73046_m());
        }
        firepositions.put(world, new CopyOnWriteArrayList());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Unload e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        for (BlockPos firepos : firepositions.get(world)) {
            BlockState firestate = world.func_180495_p(firepos);
            Block fireblock = firestate.func_177230_c();
            if (!(fireblock instanceof FireBlock)) continue;
            world.func_175656_a(firepos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @SubscribeEvent
    public void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        BlockState state = e.getState();
        Block block = state.func_177230_c();
        if (!(block instanceof FireBlock)) {
            return;
        }
        BlockPos pos = e.getPos().func_185334_h();
        Block belowblock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (BlockFunctions.isOneOfBlocks(fireblocks, (Block)belowblock).booleanValue()) {
            return;
        }
        ticksleft.put(pos, Util.getFireBurnDurationInTicks());
        firepositions.get(world).add(pos);
    }
}

