/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.cyclepaintings.util;

import com.natamus.cyclepaintings.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    private static List<PaintingType> paintingtypes = new ArrayList<PaintingType>();

    public static void setPaintings() {
        String[] allignore = ((String)ConfigHandler.GENERAL.ignorePaintingsInCycleResourceLocation.get()).split(",");
        boolean debug = (Boolean)ConfigHandler.GENERAL.showRegisteredPaintingsDebug.get();
        if (debug) {
            System.out.println("[Cycle Paintings Debug] The config option 'showRegisteredPaintingsDebug' has been enabled. Showing paintings during cycle registration.");
        }
        for (ResourceLocation motiverl : ForgeRegistries.PAINTING_TYPES.getKeys()) {
            if (motiverl == null) continue;
            boolean allowed = true;
            String motiverls = motiverl.toString().toLowerCase();
            for (String toignore : allignore) {
                if ((toignore = toignore.toLowerCase().trim()).contains(":")) {
                    if (!motiverls.equals(toignore)) continue;
                    allowed = false;
                    break;
                }
                if (!motiverls.split(":")[0].contains(toignore)) continue;
                allowed = false;
                break;
            }
            if (!allowed) {
                if (!debug) continue;
                System.out.println("[Cycle Paintings Debug] " + motiverls + " (ignored)");
                continue;
            }
            if (debug) {
                System.out.println("[Cycle Paintings Debug] " + motiverls + " (allowed)");
            }
            PaintingType motive = (PaintingType)ForgeRegistries.PAINTING_TYPES.getValue(motiverl);
            paintingtypes.add(motive);
        }
    }

    public static List<PaintingType> getSimilarArt(PaintingType currentart) {
        ArrayList<PaintingType> similarart = new ArrayList<PaintingType>();
        int xsize = currentart.func_200834_b();
        int ysize = currentart.func_200832_c();
        for (PaintingType aa : paintingtypes) {
            if (aa.func_200834_b() != xsize || aa.func_200832_c() != ysize) continue;
            similarart.add(aa);
        }
        return similarart;
    }
}

