/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.geysermod;

import com.mojang.serialization.Codec;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.przemyk.geysermod.blocks.GeyserBlock;
import xyz.przemyk.geysermod.blocks.NetherGeyserBlock;
import xyz.przemyk.geysermod.blocks.RedstoneGeyserBlock;
import xyz.przemyk.geysermod.blocks.RedstoneNetherGeyserBlock;
import xyz.przemyk.geysermod.worldgen.GeyserFeature;
import xyz.przemyk.geysermod.worldgen.NetherGeyserFeature;

public class Registration {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"geysermod");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"geysermod");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"geysermod");
    public static final RegistryObject<GeyserBlock> GEYSER_BLOCK = BLOCKS.register("geyser", GeyserBlock::new);
    public static final RegistryObject<NetherGeyserBlock> NETHER_GEYSER_BLOCK = BLOCKS.register("nether_geyser", NetherGeyserBlock::new);
    public static final RegistryObject<RedstoneGeyserBlock> REDSTONE_GEYSER_BLOCK = BLOCKS.register("redstone_geyser", RedstoneGeyserBlock::new);
    public static final RegistryObject<RedstoneNetherGeyserBlock> REDSTONE_NETHER_GEYSER_BLOCK = BLOCKS.register("redstone_nether_geyser", RedstoneNetherGeyserBlock::new);
    public static final ItemGroup GEYSER_ITEM_GROUP = new ItemGroup(ItemGroup.field_78032_a.length, "geysermod"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)GEYSER_ITEM.get());
        }
    };
    public static final RegistryObject<BlockItem> GEYSER_ITEM = ITEMS.register("geyser", () -> new BlockItem((Block)GEYSER_BLOCK.get(), new Item.Properties().func_200916_a(GEYSER_ITEM_GROUP)));
    public static final RegistryObject<BlockItem> NETHER_GEYSER_ITEM = ITEMS.register("nether_geyser", () -> new BlockItem((Block)NETHER_GEYSER_BLOCK.get(), new Item.Properties().func_200916_a(GEYSER_ITEM_GROUP)));
    public static final RegistryObject<BlockItem> REDSTONE_GEYSER_ITEM = ITEMS.register("redstone_geyser", () -> new BlockItem((Block)REDSTONE_GEYSER_BLOCK.get(), new Item.Properties().func_200916_a(GEYSER_ITEM_GROUP)));
    public static final RegistryObject<BlockItem> REDSTONE_NETHER_GEYSER_ITEM = ITEMS.register("redstone_nether_geyser", () -> new BlockItem((Block)REDSTONE_NETHER_GEYSER_BLOCK.get(), new Item.Properties().func_200916_a(GEYSER_ITEM_GROUP)));
    public static final RegistryObject<GeyserFeature> GEYSER_FEATURE = FEATURES.register("geyser_feature", () -> new GeyserFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<NetherGeyserFeature> NETHER_GEYSER_FEATURE = FEATURES.register("nether_geyser_feature", () -> new NetherGeyserFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static ConfiguredFeature<?, ?> GEYSER_CONFIGURED_FEATURE;
    public static ConfiguredFeature<?, ?> NETHER_GEYSER_CONFIGURED_FEATURE;

    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        FEATURES.register(eventBus);
        eventBus.addListener(Registration::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(Registration::addFeatures);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GEYSER_CONFIGURED_FEATURE = ((GeyserFeature)GEYSER_FEATURE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("geysermod", "geyser"), (Object)GEYSER_CONFIGURED_FEATURE);
            BlockClusterFeatureConfig NETHER_GEYSER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((NetherGeyserBlock)NETHER_GEYSER_BLOCK.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(10).func_227317_b_().func_227322_d_();
            NETHER_GEYSER_CONFIGURED_FEATURE = ((NetherGeyserFeature)NETHER_GEYSER_FEATURE.get()).func_225566_b_((IFeatureConfig)NETHER_GEYSER_CONFIG).func_227228_a_(Placement.field_236960_A_.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(10)));
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("geysermod", "nether_geyser"), (Object)NETHER_GEYSER_CONFIGURED_FEATURE);
        });
    }

    private static void addFeatures(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.EXTREME_HILLS) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.LOCAL_MODIFICATIONS).add(() -> GEYSER_CONFIGURED_FEATURE);
        } else if (category == Biome.Category.NETHER) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> NETHER_GEYSER_CONFIGURED_FEATURE);
        }
    }
}

