/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.waterdripsound;

import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.gui.entries.BooleanListEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;

public class WaterDripSoundConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    static final ForgeConfigSpec spec = BUILDER.build();

    static void registerClothConfig() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (client, parent) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((ITextComponent)new TranslationTextComponent("config.waterdripsound.general"));
            builder.setDefaultBackgroundTexture(new ResourceLocation("minecraft:textures/block/mossy_stone_bricks.png"));
            builder.transparentBackground();
            ConfigEntryBuilder eb = builder.entryBuilder();
            ConfigCategory general = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("key.waterdripsound.category"));
            general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.waterdripsound.enable"), ((Boolean)WaterDripSoundConfig.GENERAL.enabled.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> WaterDripSoundConfig.GENERAL.enabled.set(arg_0)).build());
            general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.waterdripsound.volume"), (int)((Double)WaterDripSoundConfig.GENERAL.volume.get() * 100.0), 0, 100).setDefaultValue(30).setTextGetter(integer -> new StringTextComponent("Volume: " + integer + "%")).setSaveConsumer(integer -> WaterDripSoundConfig.GENERAL.volume.set((Object)((double)integer.intValue() / 100.0))).build());
            general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.waterdripsound.dripChance"), ((Integer)WaterDripSoundConfig.GENERAL.dripChance.get()).intValue(), 1, 100).setDefaultValue(10).setTextGetter(integer -> new StringTextComponent("One in " + integer)).setSaveConsumer(arg_0 -> WaterDripSoundConfig.GENERAL.dripChance.set(arg_0)).build());
            BooleanListEntry ble = eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.waterdripsound.useDripstoneSounds"), false).setDefaultValue(false).setYesNoTextSupplier(aBoolean -> new StringTextComponent(TextFormatting.GRAY + "Unavailable")).setTooltip(new ITextComponent[]{new TranslationTextComponent("tooltip.config.waterdripsound.useDripstoneSounds.cannot")}).build();
            ble.setEditable(false);
            general.addEntry((AbstractConfigListEntry)ble);
            general.addEntry((AbstractConfigListEntry)eb.startEnumSelector((ITextComponent)new TranslationTextComponent("config.waterdripsound.soundCategory"), SoundCategory.class, (Enum)WaterDripSoundConfig.GENERAL.soundCategory.get()).setDefaultValue((Enum)SoundCategory.AMBIENT).setEnumNameProvider(anEnum -> new TranslationTextComponent("soundCategory." + ((SoundCategory)anEnum).func_187948_a())).setSaveConsumer(arg_0 -> WaterDripSoundConfig.GENERAL.soundCategory.set(arg_0)).build());
            return builder.setSavingRunnable(() -> ((ForgeConfigSpec)spec).save()).build();
        });
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> enabled;
        public final ForgeConfigSpec.ConfigValue<Double> volume;
        public final ForgeConfigSpec.ConfigValue<Integer> dripChance;
        public final ForgeConfigSpec.ConfigValue<SoundCategory> soundCategory;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.enabled = builder.comment("Enables/Disables the whole Mod [false/true|default:true]").translation("enable.waterdripsound.config").define("enableMod", true);
            this.volume = builder.comment("Volume of water/lava drips [0.0-1.0|default:0.3]").translation("volume.waterdripsound.config").define("volume", (Object)0.3);
            this.dripChance = builder.comment("Chance of a drip forming each tick (one in X so lower is faster) [1-100|default:10]").translation("dripChance.waterdripsound.config").define("dripChance", (Object)10);
            this.soundCategory = builder.comment("Sound category [default:AMBIENT]").translation("soundCategory.waterdripsound.config").define("soundCategory", (Object)SoundCategory.AMBIENT);
            builder.pop();
        }
    }
}

