/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.IntegerListListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class IntListBuilder
extends FieldBuilder<List<Integer>, IntegerListListEntry> {
    protected Function<Integer, Optional<class_2561>> cellErrorSupplier;
    private Consumer<List<Integer>> saveConsumer = null;
    private Function<List<Integer>, Optional<class_2561[]>> tooltipSupplier = list -> Optional.empty();
    private final List<Integer> value;
    private boolean expanded = false;
    private Integer min = null;
    private Integer max = null;
    private Function<IntegerListListEntry, IntegerListListEntry.IntegerListCell> createNewInstance;
    private class_2561 addTooltip = new class_2588("text.cloth-config.list.add");
    private class_2561 removeTooltip = new class_2588("text.cloth-config.list.remove");
    private boolean deleteButtonEnabled = true;
    private boolean insertInFront = false;

    public IntListBuilder(class_2561 resetButtonKey, class_2561 fieldNameKey, List<Integer> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public Function<Integer, Optional<class_2561>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public IntListBuilder setCellErrorSupplier(Function<Integer, Optional<class_2561>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
        return this;
    }

    public IntListBuilder setErrorSupplier(Function<List<Integer>, Optional<class_2561>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public IntListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
        return this;
    }

    public IntListBuilder setInsertInFront(boolean insertInFront) {
        this.insertInFront = insertInFront;
        return this;
    }

    public IntListBuilder setAddButtonTooltip(class_2561 addTooltip) {
        this.addTooltip = addTooltip;
        return this;
    }

    public IntListBuilder setRemoveButtonTooltip(class_2561 removeTooltip) {
        this.removeTooltip = removeTooltip;
        return this;
    }

    public IntListBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public IntListBuilder setCreateNewInstance(Function<IntegerListListEntry, IntegerListListEntry.IntegerListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    public IntListBuilder setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public IntListBuilder setExpended(boolean expanded) {
        return this.setExpanded(expanded);
    }

    public IntListBuilder setSaveConsumer(Consumer<List<Integer>> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public IntListBuilder setDefaultValue(Supplier<List<Integer>> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public IntListBuilder setMin(int min) {
        this.min = min;
        return this;
    }

    public IntListBuilder setMax(int max) {
        this.max = max;
        return this;
    }

    public IntListBuilder removeMin() {
        this.min = null;
        return this;
    }

    public IntListBuilder removeMax() {
        this.max = null;
        return this;
    }

    public IntListBuilder setDefaultValue(List<Integer> defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public IntListBuilder setTooltipSupplier(Function<List<Integer>, Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public IntListBuilder setTooltipSupplier(Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = list -> (Optional)tooltipSupplier.get();
        return this;
    }

    public IntListBuilder setTooltip(Optional<class_2561[]> tooltip) {
        this.tooltipSupplier = list -> tooltip;
        return this;
    }

    public IntListBuilder setTooltip(class_2561 ... tooltip) {
        this.tooltipSupplier = list -> Optional.ofNullable(tooltip);
        return this;
    }

    @Override
    @NotNull
    public IntegerListListEntry build() {
        IntegerListListEntry entry = new IntegerListListEntry(this.getFieldNameKey(), this.value, this.expanded, null, this.saveConsumer, this.defaultValue, this.getResetButtonKey(), this.isRequireRestart(), this.deleteButtonEnabled, this.insertInFront);
        if (this.min != null) {
            entry.setMinimum(this.min);
        }
        if (this.max != null) {
            entry.setMaximum(this.max);
        }
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply((List<Integer>)entry.getValue()));
        entry.setAddTooltip(this.addTooltip);
        entry.setRemoveTooltip(this.removeTooltip);
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

