/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.FloatListListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class FloatListBuilder
extends FieldBuilder<List<Float>, FloatListListEntry> {
    protected Function<Float, Optional<class_2561>> cellErrorSupplier;
    private Consumer<List<Float>> saveConsumer = null;
    private Function<List<Float>, Optional<class_2561[]>> tooltipSupplier = list -> Optional.empty();
    private final List<Float> value;
    private boolean expanded = false;
    private Float min = null;
    private Float max = null;
    private Function<FloatListListEntry, FloatListListEntry.FloatListCell> createNewInstance;
    private class_2561 addTooltip = new class_2588("text.cloth-config.list.add");
    private class_2561 removeTooltip = new class_2588("text.cloth-config.list.remove");
    private boolean deleteButtonEnabled = true;
    private boolean insertInFront = false;

    public FloatListBuilder(class_2561 resetButtonKey, class_2561 fieldNameKey, List<Float> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public Function<Float, Optional<class_2561>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public FloatListBuilder setCellErrorSupplier(Function<Float, Optional<class_2561>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
        return this;
    }

    public FloatListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
        return this;
    }

    public FloatListBuilder setErrorSupplier(Function<List<Float>, Optional<class_2561>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public FloatListBuilder setInsertInFront(boolean insertInFront) {
        this.insertInFront = insertInFront;
        return this;
    }

    public FloatListBuilder setAddButtonTooltip(class_2561 addTooltip) {
        this.addTooltip = addTooltip;
        return this;
    }

    public FloatListBuilder setRemoveButtonTooltip(class_2561 removeTooltip) {
        this.removeTooltip = removeTooltip;
        return this;
    }

    public FloatListBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public FloatListBuilder setCreateNewInstance(Function<FloatListListEntry, FloatListListEntry.FloatListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    public FloatListBuilder setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public FloatListBuilder setExpended(boolean expanded) {
        return this.setExpanded(expanded);
    }

    public FloatListBuilder setSaveConsumer(Consumer<List<Float>> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public FloatListBuilder setDefaultValue(Supplier<List<Float>> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public FloatListBuilder setMin(float min) {
        this.min = Float.valueOf(min);
        return this;
    }

    public FloatListBuilder setMax(float max) {
        this.max = Float.valueOf(max);
        return this;
    }

    public FloatListBuilder removeMin() {
        this.min = null;
        return this;
    }

    public FloatListBuilder removeMax() {
        this.max = null;
        return this;
    }

    public FloatListBuilder setDefaultValue(List<Float> defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public FloatListBuilder setTooltipSupplier(Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = list -> (Optional)tooltipSupplier.get();
        return this;
    }

    public FloatListBuilder setTooltipSupplier(Function<List<Float>, Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public FloatListBuilder setTooltip(Optional<class_2561[]> tooltip) {
        this.tooltipSupplier = list -> tooltip;
        return this;
    }

    public FloatListBuilder setTooltip(class_2561 ... tooltip) {
        this.tooltipSupplier = list -> Optional.ofNullable(tooltip);
        return this;
    }

    @Override
    @NotNull
    public FloatListListEntry build() {
        FloatListListEntry entry = new FloatListListEntry(this.getFieldNameKey(), this.value, this.expanded, null, this.saveConsumer, this.defaultValue, this.getResetButtonKey(), this.isRequireRestart(), this.deleteButtonEnabled, this.insertInFront);
        if (this.min != null) {
            entry.setMinimum(this.min.floatValue());
        }
        if (this.max != null) {
            entry.setMaximum(this.max.floatValue());
        }
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply((List<Float>)entry.getValue()));
        entry.setAddTooltip(this.addTooltip);
        entry.setRemoveTooltip(this.removeTooltip);
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

