/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import atomicstryker.multimine.common.network.PartialBlockRemovalPacket;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MultiMineServer {
    private static MultiMineServer instance;
    private static MinecraftServer serverInstance;
    private final HashMap<ResourceKey<Level>, List<PartiallyMinedBlock>> partiallyMinedBlocksListByDimension;
    private final BlockRegenQueue blockRegenQueue;

    public MultiMineServer() {
        MultiMine.LOGGER.info("MultiMineServer initializing");
        instance = this;
        this.partiallyMinedBlocksListByDimension = Maps.newHashMap();
        this.blockRegenQueue = new BlockRegenQueue(30, new BlockAgeComparator());
    }

    public static MultiMineServer instance() {
        return instance;
    }

    public void onClientSentPartialBlockPacket(ServerPlayer player, int x, int y, int z, float value) {
        serverInstance = ServerLifecycleHooks.getCurrentServer();
        ResourceKey dimension = player.m_183503_().m_46472_();
        MultiMine.instance().debugPrint("multi mine client {} sent progress packet: {}", player.m_7755_().m_6111_(), Float.valueOf(value));
        BlockPos pos = new BlockPos(x, y, z);
        BlockState iblockstate = player.m_183503_().m_8055_(pos);
        if (this.isUsingBannedItem((Player)player) || this.isBlockBanned(iblockstate) || this.isItemTagBanned(player.m_21205_()) || this.isBlockTagBanned(iblockstate)) {
            this.sendPartiallyMinedBlockToPlayer(player, new PartiallyMinedBlock(x, y, z, (ResourceKey<Level>)dimension, -1.0f));
            return;
        }
        ArrayList partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension((ResourceKey<Level>)dimension);
        if (partiallyMinedBlocks == null) {
            partiallyMinedBlocks = Lists.newArrayList();
            this.partiallyMinedBlocksListByDimension.put((ResourceKey<Level>)dimension, partiallyMinedBlocks);
        }
        PartiallyMinedBlock newblock = new PartiallyMinedBlock(x, y, z, (ResourceKey<Level>)dimension, 0.0f);
        newblock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
        for (PartiallyMinedBlock iterBlock : partiallyMinedBlocks) {
            if (!iterBlock.equals(newblock)) continue;
            iterBlock.setProgress(Math.max(iterBlock.getProgress(), value));
            iterBlock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
            MultiMine.instance().debugPrint("Server updating partial block at: [{}|{}|{}], progress now: {}", x, y, z, Float.valueOf(iterBlock.getProgress()));
            this.sendPartiallyMinedBlockUpdateToAllPlayers(iterBlock, false);
            if (iterBlock.isFinished() && !player.m_183503_().m_8055_(pos).m_60795_()) {
                MultiMine.instance().debugPrint("Server destroying block at: [{}|{}|{}]", x, y, z);
                player.f_8941_.m_9280_(pos);
                partiallyMinedBlocks.remove(iterBlock);
                this.blockRegenQueue.remove(iterBlock);
            } else {
                this.blockRegenQueue.offer(iterBlock);
            }
            return;
        }
        if (partiallyMinedBlocks.size() > 29) {
            PartiallyMinedBlock old = (PartiallyMinedBlock)partiallyMinedBlocks.get(0);
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(old);
            partiallyMinedBlocks.remove(old);
            this.blockRegenQueue.remove(old);
        }
        partiallyMinedBlocks.add(newblock);
        this.blockRegenQueue.offer(newblock);
        this.sendPartiallyMinedBlockUpdateToAllPlayers(newblock, false);
    }

    private boolean isBlockBanned(BlockState blockState) {
        String blockIdentifier = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.m_60734_()).toString();
        Boolean result = MultiMine.instance().getConfig().getBannedBlocks().get(blockIdentifier);
        if (result != null) {
            return result;
        }
        result = false;
        MultiMine.instance().getConfig().getBannedBlocks().put(blockIdentifier, result);
        MultiMine.instance().saveConfig();
        return result;
    }

    private boolean isBlockTagBanned(BlockState blockState) {
        return blockState.m_204343_().anyMatch(blockTagKey -> {
            Boolean boolForTag = MultiMine.instance().getConfig().getBannedBlocks().get(blockTagKey.f_203868_().toString());
            return Objects.requireNonNullElse(boolForTag, false);
        });
    }

    private boolean isUsingBannedItem(Player player) {
        ItemStack item = player.m_21205_();
        String ident = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.m_41720_()).toString();
        Boolean result = MultiMine.instance().getConfig().getBannedItems().get(ident);
        if (result != null) {
            return result;
        }
        result = false;
        MultiMine.instance().getConfig().getBannedItems().put(ident, result);
        MultiMine.instance().saveConfig();
        return result;
    }

    private boolean isItemTagBanned(ItemStack handItem) {
        return handItem.m_204131_().anyMatch(itemTagKey -> {
            Boolean boolForTag = MultiMine.instance().getConfig().getBannedItems().get(itemTagKey.f_203868_().toString());
            return Objects.requireNonNullElse(boolForTag, false);
        });
    }

    private void sendPartiallyMinedBlockDeleteCommandToAllPlayers(PartiallyMinedBlock block) {
        MultiMine.instance().networkHelper.sendPacketToAllAroundPoint(new PartialBlockRemovalPacket(block.getPos()), new PacketDistributor.TargetPoint((double)block.getPos().m_123341_(), (double)block.getPos().m_123342_(), (double)block.getPos().m_123343_(), 30.0, block.getDimension()));
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MultiMineServer.instance().onPlayerLoginInstance(event);
    }

    private void onPlayerLoginInstance(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        ResourceKey dimensionKey = player.m_183503_().m_46472_();
        List<PartiallyMinedBlock> partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension((ResourceKey<Level>)dimensionKey);
        if (partiallyMinedBlocks != null) {
            for (PartiallyMinedBlock block : partiallyMinedBlocks) {
                this.sendPartiallyMinedBlockToPlayer((ServerPlayer)player, block);
            }
        }
    }

    private List<PartiallyMinedBlock> getPartiallyMinedBlocksForDimension(ResourceKey<Level> dim) {
        return this.partiallyMinedBlocksListByDimension.get(dim);
    }

    private void sendPartiallyMinedBlockUpdateToAllPlayers(PartiallyMinedBlock block, boolean regenerating) {
        MultiMine.instance().networkHelper.sendPacketToAllAroundPoint(new PartialBlockPacket("server", block.getPos().m_123341_(), block.getPos().m_123342_(), block.getPos().m_123343_(), block.getProgress(), regenerating), new PacketDistributor.TargetPoint((double)block.getPos().m_123341_(), (double)block.getPos().m_123342_(), (double)block.getPos().m_123343_(), 32.0, block.getDimension()));
    }

    private void sendPartiallyMinedBlockToPlayer(ServerPlayer p, PartiallyMinedBlock block) {
        MultiMine.instance().networkHelper.sendPacketToPlayer(new PartialBlockPacket("server", block.getPos().m_123341_(), block.getPos().m_123342_(), block.getPos().m_123343_(), block.getProgress(), false), p);
    }

    @SubscribeEvent
    public void commonSetup(ServerStartedEvent evt) {
        MultiMine.LOGGER.info("MultiMine ServerStartedEvent");
        MultiMine.instance().initIfNeeded((Level)evt.getServer().m_129785_().iterator().next());
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent tick) {
        PartiallyMinedBlock block;
        if (tick.phase != TickEvent.Phase.END || this.blockRegenQueue.isEmpty()) {
            return;
        }
        Iterator iter = this.blockRegenQueue.iterator();
        while (iter.hasNext()) {
            block = (PartiallyMinedBlock)iter.next();
            if (!this.isBlockGone(block)) continue;
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
            this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
            iter.remove();
        }
        if (this.blockRegenQueue.isEmpty() || !MultiMine.instance().getBlockRegenEnabled()) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (((PartiallyMinedBlock)this.blockRegenQueue.peek()).getLastTimeMined() + MultiMine.instance().getBlockRegenInterval() < curTime) {
            block = (PartiallyMinedBlock)this.blockRegenQueue.poll();
            block.setProgress(block.getProgress() - 0.1f);
            block.setLastTimeMined(curTime);
            if (block.getProgress() < 0.0f) {
                MultiMine.instance().debugPrint("Server sending partial delete command for [{}|{}|{}]", block.getPos().m_123341_(), block.getPos().m_123342_(), block.getPos().m_123343_());
                this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
                this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
            } else {
                MultiMine.instance().debugPrint("Server sending partial regen update for [{}|{}|{}]", block.getPos().m_123341_(), block.getPos().m_123342_(), block.getPos().m_123343_());
                this.sendPartiallyMinedBlockUpdateToAllPlayers(block, true);
                this.blockRegenQueue.add(block);
            }
        }
    }

    private boolean isBlockGone(PartiallyMinedBlock block) {
        return serverInstance.m_129880_(block.getDimension()).m_46859_(block.getPos());
    }

    private static class BlockRegenQueue
    extends PriorityQueue<PartiallyMinedBlock> {
        private static final long serialVersionUID = 1L;

        BlockRegenQueue(int initialSize, Comparator<PartiallyMinedBlock> comparator) {
            super(initialSize, comparator);
        }

        @Override
        public boolean offer(PartiallyMinedBlock block) {
            if (this.contains(block)) {
                this.remove(block);
            }
            return super.offer(block);
        }
    }

    private static class BlockAgeComparator
    implements Comparator<PartiallyMinedBlock> {
        private BlockAgeComparator() {
        }

        @Override
        public int compare(PartiallyMinedBlock b1, PartiallyMinedBlock b2) {
            return Long.compare(b1.getLastTimeMined(), b2.getLastTimeMined());
        }
    }
}

