/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawningshulkers.events;

import com.natamus.collective.functions.WorldFunctions;
import com.natamus.respawningshulkers.config.ConfigHandler;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

@Mod.EventBusSubscriber
public class ShulkerEvent {
    private static HashMap<Entity, Integer> shulkersTicksLeft = new HashMap();
    private static HashMap<World, CopyOnWriteArrayList<Entity>> respawnShulkers = new HashMap();

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        respawnShulkers.put(world, new CopyOnWriteArrayList());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (respawnShulkers.get(world).size() > 0) {
            for (Entity shulker : respawnShulkers.get(world)) {
                int ticksleft = shulkersTicksLeft.get(shulker) - 1;
                if (ticksleft == 0) {
                    respawnShulkers.get(world).remove(shulker);
                    shulkersTicksLeft.remove(shulker);
                    world.func_217376_c(shulker);
                    continue;
                }
                shulkersTicksLeft.put(shulker, ticksleft);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onShulkerDeath(LivingDeathEvent e) {
        Entity entity = e.getEntity();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof ShulkerEntity)) {
            return;
        }
        if (e.isCanceled()) {
            return;
        }
        Set tags = entity.func_184216_O();
        if (tags.contains("respawningshulkers.fromspawner") && ((Boolean)ConfigHandler.GENERAL.shulkersFromSpawnersDoNotRespawn.get()).booleanValue()) {
            return;
        }
        ShulkerEntity newshulker = (ShulkerEntity)EntityType.field_200738_ad.func_200721_a(world);
        newshulker.func_180432_n(entity);
        newshulker.func_70606_j(30.0f);
        shulkersTicksLeft.put((Entity)newshulker, (Integer)ConfigHandler.GENERAL.timeInTicksToRespawn.get());
        respawnShulkers.get(world).add((Entity)newshulker);
    }

    @SubscribeEvent
    public void onMobCheckSpawn(LivingSpawnEvent.CheckSpawn e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof ShulkerEntity)) {
            return;
        }
        if (e.getSpawner() != null) {
            entity.func_184211_a("respawningshulkers.fromspawner");
        }
    }

    @SubscribeEvent
    public void onServerShutdown(FMLServerStoppingEvent e) {
        Set<World> worlds = respawnShulkers.keySet();
        for (World world : worlds) {
            for (Entity shulker : respawnShulkers.get(world)) {
                world.func_217376_c(shulker);
            }
        }
    }
}

