/*
 * Decompiled with CFR 0.152.
 */
package ImageMod.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.FileNotFoundException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;

public class PathArgument
implements ArgumentType<Path> {
    private static Collection<String> EXAMPLES = Arrays.asList("\"" + System.getProperty("user.home") + "\"");
    private static SimpleCommandExceptionType PATH_NOT_FOUND = new SimpleCommandExceptionType((Message)new LiteralMessage("Path not found"));
    public Path rootDir = null;

    public PathArgument() {
        try {
            this.rootDir = this.getPath(System.getProperty("user.home"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Path getPath(Path path) throws FileNotFoundException {
        if (this.rootDir != null) {
            try {
                Path ret = this.rootDir.resolve(path);
                if (ret.toFile().exists()) {
                    return ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (path.toFile().exists()) {
                return path;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException();
    }

    public Path getPath(String str) throws FileNotFoundException {
        try {
            return this.getPath(Paths.get(str, new String[0]));
        }
        catch (Exception exception) {
            throw new FileNotFoundException();
        }
    }

    public Path getDirectory(Path path) throws FileNotFoundException, NotDirectoryException {
        Path dir = this.getPath(path);
        if (!dir.toFile().isDirectory()) {
            throw new NotDirectoryException(path.toFile().getPath());
        }
        return dir;
    }

    public Path getDirectory(String str) throws FileNotFoundException, NotDirectoryException {
        Path ret = null;
        try {
            ret = this.getPath(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDirectory(ret);
    }

    public void setRootDirectory(Path path) throws FileNotFoundException, NotDirectoryException {
        this.rootDir = this.getDirectory(path);
    }

    public void setRootDirectory(String dir) throws FileNotFoundException, NotDirectoryException {
        this.rootDir = this.getDirectory(dir);
    }

    public Path parse(StringReader reader) throws CommandSyntaxException {
        Path ret;
        String str = StringArgumentType.string().parse(reader);
        try {
            ret = this.getPath(str);
        }
        catch (FileNotFoundException e) {
            throw PATH_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
        }
        return ret;
    }

    public static Path getPath(CommandContext<CommandSource> context, String name) {
        return (Path)context.getArgument(name, Path.class);
    }

    private String getFormattedPathString(Path path) {
        String ret = "";
        Path relative = this.rootDir.relativize(path);
        Path placeholder = !relative.toString().contains("..") ? relative : path;
        ret = path.toFile().isDirectory() ? placeholder.toString() + "/" : placeholder.toString();
        ret = ret.replace("\\", "/");
        return ret;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        int dirIndex;
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        String totalString = null;
        String pathStr = null;
        String searchString = null;
        try {
            totalString = StringArgumentType.string().parse(stringReader);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (totalString != null && (dirIndex = totalString.lastIndexOf("/") + 1) >= 0) {
            pathStr = totalString.substring(0, dirIndex);
            searchString = totalString.substring(dirIndex);
        }
        try {
            Path path = this.getPath(pathStr);
            int i = 0;
            for (String str : path.toFile().list()) {
                if (str.indexOf(searchString) != 0) continue;
                if (++i <= 100) {
                    String suggestion = this.getFormattedPathString(path.resolve(str));
                    builder.suggest("\"" + suggestion + "\"");
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

