/*
 * Decompiled with CFR 0.152.
 */
package ImageMod.commands;

import ImageMod.ImageBuilder.BlockImageBuilder;
import ImageMod.ImageBuilder.BlockImageCreationData;
import ImageMod.ImageBuilder.ImageBlock;
import ImageMod.ImageBuilder.ResizeableImage;
import ImageMod.WorldTransformer.WorldTransformAction;
import ImageMod.util.DirectoryArgument;
import ImageMod.util.PathArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CoralBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImageCommand {
    public static ArrayList<ImageBlock> blockList;
    private static final Logger LOGGER;
    private static final PathArgument imageSourceArgument;
    public static Stack<WorldTransformAction> undoStack;
    public static Stack<WorldTransformAction> redoStack;

    public static void setup() {
        try {
            ImageCommand.setRootDirectory(System.getProperty("user.home") + "/Downloads");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        ImageCommand.setup();
        LiteralArgumentBuilder root = Commands.func_197057_a((String)"image");
        LiteralArgumentBuilder createLiteral = (LiteralArgumentBuilder)Commands.func_197057_a((String)"create").requires(source -> source.func_197034_c(2));
        LiteralArgumentBuilder wLiteral = Commands.func_197057_a((String)"-width");
        LiteralArgumentBuilder hLiteral = Commands.func_197057_a((String)"-height");
        LiteralArgumentBuilder whInfoLiteral = Commands.func_197057_a((String)"~ ~");
        RequiredArgumentBuilder srcArgument = Commands.func_197056_a((String)"src", (ArgumentType)imageSourceArgument);
        RequiredArgumentBuilder wArgument = Commands.func_197056_a((String)"width", (ArgumentType)IntegerArgumentType.integer());
        RequiredArgumentBuilder wArgumentFinal = (RequiredArgumentBuilder)Commands.func_197056_a((String)"width", (ArgumentType)IntegerArgumentType.integer()).executes(ImageCommand::createImageCommand);
        RequiredArgumentBuilder hArgumentFinal = (RequiredArgumentBuilder)Commands.func_197056_a((String)"height", (ArgumentType)IntegerArgumentType.integer()).executes(ImageCommand::createImageCommand);
        LiteralArgumentBuilder reload = (LiteralArgumentBuilder)Commands.func_197057_a((String)"reload").executes(ImageCommand::reloadCommand);
        wLiteral.then((ArgumentBuilder)wArgumentFinal);
        hLiteral.then((ArgumentBuilder)hArgumentFinal);
        wArgument.then((ArgumentBuilder)hArgumentFinal);
        ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)srcArgument.then((ArgumentBuilder)wLiteral)).then((ArgumentBuilder)hLiteral)).then((ArgumentBuilder)whInfoLiteral)).then((ArgumentBuilder)wArgument);
        createLiteral.then((ArgumentBuilder)srcArgument);
        LiteralArgumentBuilder undoLiteral = (LiteralArgumentBuilder)Commands.func_197057_a((String)"undo").executes(ImageCommand::undoCommand);
        LiteralArgumentBuilder redoLiteral = (LiteralArgumentBuilder)Commands.func_197057_a((String)"redo").executes(ImageCommand::redoCommand);
        LiteralArgumentBuilder setDirectoryLiteral = Commands.func_197057_a((String)"setDirectory");
        RequiredArgumentBuilder directoryArgument = (RequiredArgumentBuilder)Commands.func_197056_a((String)"dir", (ArgumentType)new DirectoryArgument()).executes(ImageCommand::setDirectoryCommand);
        setDirectoryLiteral.then((ArgumentBuilder)directoryArgument);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then((ArgumentBuilder)createLiteral)).then((ArgumentBuilder)setDirectoryLiteral)).then((ArgumentBuilder)reload)).then((ArgumentBuilder)undoLiteral)).then((ArgumentBuilder)redoLiteral);
        dispatcher.register(root);
    }

    public static void setRootDirectory(Path path) throws NotDirectoryException, FileNotFoundException {
        imageSourceArgument.setRootDirectory(path);
    }

    public static void setRootDirectory(String dir) throws NotDirectoryException, FileNotFoundException {
        imageSourceArgument.setRootDirectory(dir);
    }

    public static void reload() {
        ImageCommand.updateBlockList();
        LOGGER.info("Reload complete.");
    }

    public static void updateBlockList() {
        blockList = ImageCommand.filterBlocks(ForgeRegistries.BLOCKS.getValues());
        LOGGER.info("Block list update complete.");
    }

    private static int createImageCommand(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ResizeableImage image = null;
        int w = 0;
        int h = 0;
        boolean wset = false;
        boolean hset = false;
        try {
            w = IntegerArgumentType.getInteger(ctx, (String)"width");
            wset = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            h = IntegerArgumentType.getInteger(ctx, (String)"height");
            hset = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path path = PathArgument.getPath(ctx, "src");
        try {
            image = new ResizeableImage(ImageIO.read(path.toFile()));
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage());
        }
        if (!wset && !hset) {
            return -1;
        }
        if (!wset) {
            w = h * image.width / image.height;
        } else if (!hset) {
            h = w * image.height / image.width;
        }
        CommandSource source = (CommandSource)ctx.getSource();
        Entity entity = source.func_197022_f();
        ServerWorld world = source.func_197023_e();
        Direction viewDir = entity.func_174811_aO();
        Direction rightDir = viewDir.func_176746_e();
        BlockPos startPos = entity.func_233580_cy_().func_177967_a(viewDir, 2);
        int ww = w;
        int hh = h;
        BlockImageCreationData creationData = new BlockImageCreationData();
        creationData.image = image;
        creationData.world = world;
        creationData.pos = startPos;
        creationData.xDir = rightDir;
        creationData.yDir = Direction.UP;
        creationData.zDir = viewDir;
        creationData.blockWidth = w;
        creationData.blockHeight = h;
        creationData.onError = e -> source.func_197021_a((ITextComponent)new StringTextComponent(e.getMessage()));
        creationData.onSuccess = transform -> {
            source.func_197030_a((ITextComponent)new StringTextComponent(String.format("Successfully created (%dx%d) image", ww, hh)), true);
            transform.performAction();
            undoStack.push((WorldTransformAction)transform);
        };
        ImageCommand.createImage(creationData);
        return 1;
    }

    private static int undoCommand(CommandContext<CommandSource> ctx) {
        if (undoStack.empty()) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Undo stack is empty"));
            return -1;
        }
        WorldTransformAction action = undoStack.pop();
        action.revertAction();
        redoStack.push(action);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Successfully reverted last image creation"), true);
        return 1;
    }

    private static int redoCommand(CommandContext<CommandSource> ctx) {
        if (redoStack.empty()) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Redo stack is empty"));
            return -1;
        }
        WorldTransformAction action = redoStack.pop();
        action.performAction();
        undoStack.push(action);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Successfully recreated image"), true);
        return 1;
    }

    private static int setDirectoryCommand(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Path dir = DirectoryArgument.getPath(ctx, "dir");
        try {
            imageSourceArgument.setRootDirectory(dir);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Successfully set image directory to \"" + dir.toString() + "\""), true);
            return 1;
        }
        catch (NotDirectoryException e) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Provided path is not a directory"));
        }
        catch (FileNotFoundException e) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Provided path could not be found"));
        }
        return -1;
    }

    private static int reloadCommand(CommandContext<CommandSource> ctx) {
        ImageCommand.reload();
        return 1;
    }

    private static void createImage(BlockImageCreationData creationData) {
        new BlockImageBuilder(creationData);
    }

    private static ArrayList<ImageBlock> filterBlocks(Collection<Block> blocks) {
        ArrayList<ImageBlock> ret = new ArrayList<ImageBlock>();
        Minecraft minecraft = Minecraft.func_71410_x();
        IResourceManager manager = minecraft.func_195551_G();
        Blockreader blocKReader = new Blockreader(null);
        for (Block block : blocks) {
            BlockState state = block.func_176223_P();
            Material m = state.func_185904_a();
            VoxelShape vs = state.func_196954_c((IBlockReader)blocKReader, BlockPos.field_177992_a);
            boolean applicable = true;
            if (!Block.func_208062_a((VoxelShape)vs)) {
                applicable = false;
            }
            if (!m.func_76220_a()) {
                applicable = false;
            }
            if (block.hasTileEntity(state)) {
                applicable = false;
            }
            if (block.getLightValue(state, (IBlockReader)blocKReader, BlockPos.field_177992_a) > 0) {
                applicable = false;
            }
            if (block instanceof CoralBlock) {
                applicable = false;
            }
            if (block instanceof LeavesBlock) {
                applicable = false;
            }
            if (!applicable) {
                LOGGER.error(block.func_235333_g_().getString() + " is not applicable");
                continue;
            }
            ResourceLocation bLoc = block.getRegistryName();
            ResourceLocation texture = new ResourceLocation(bLoc.func_110624_b(), "textures/block/" + bLoc.func_110623_a() + ".png");
            try {
                BufferedImage img = ImageIO.read(manager.func_199002_a(texture).func_199027_b());
                ret.add(new ImageBlock(state, new ResizeableImage(img)));
                LOGGER.info("successfully loaded: " + texture.func_110623_a());
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return ret;
    }

    static {
        LOGGER = LogManager.getLogger();
        imageSourceArgument = new PathArgument();
        undoStack = new Stack();
        redoStack = new Stack();
    }
}

