/*
 * Decompiled with CFR 0.152.
 */
package ImageMod.ImageBuilder;

import ImageMod.ImageBuilder.BlockImageCreationData;
import ImageMod.ImageBuilder.ImageBlock;
import ImageMod.ImageBuilder.ResizeableImage;
import ImageMod.WorldTransformer.WorldTransformAction;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;

public class BlockImageCreationWorker
extends Thread {
    private WorldTransformAction transform;
    private BlockImageCreationData creationData;
    private ArrayList<ImageBlock> preSized;
    private final int tileWidth;
    private final int tileHeight;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;

    public BlockImageCreationWorker(WorldTransformAction transform, BlockImageCreationData creationData, ArrayList<ImageBlock> preSized, int tileWidth, int tileHeight) {
        this.transform = transform;
        this.creationData = creationData;
        this.preSized = preSized;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    @Override
    public void run() {
        for (int y = this.yMin; y < this.yMax; ++y) {
            for (int x = this.xMin; x < this.xMax; ++x) {
                int imgX = x * this.creationData.image.width / this.creationData.blockWidth;
                int imgY = y * this.creationData.image.height / this.creationData.blockHeight;
                ResizeableImage tileImg = this.creationData.image.subImage(imgX, imgY, this.tileWidth, this.tileHeight);
                this.transform.set(x, y, this.getBestFit(tileImg, this.preSized));
            }
        }
    }

    public void setWorkload(int xMin, int xMax, int yMin, int yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    private BlockState getBestFit(ResizeableImage img, ArrayList<ImageBlock> blockList) {
        BlockState ret = Blocks.field_150350_a.func_176223_P();
        int minScore = img.getSimilarity(ResizeableImage.getTransparant(img.width, img.height));
        for (ImageBlock block : blockList) {
            int score = block.image.getSimilarity(img);
            if (score >= minScore) continue;
            minScore = score;
            ret = block.blockState;
        }
        return ret;
    }
}

