/*
 * Decompiled with CFR 0.152.
 */
package ImageMod.ImageBuilder;

import ImageMod.ImageBuilder.BlockImageCreationData;
import ImageMod.ImageBuilder.BlockImageCreationWorker;
import ImageMod.ImageBuilder.ImageBlock;
import ImageMod.ImageBuilder.ResizeableImage;
import ImageMod.WorldTransformer.WorldTransformAction;
import ImageMod.WorldTransformer.WorldTransformCreationData;
import ImageMod.commands.ImageCommand;
import java.util.ArrayList;

public class BlockImageBuilder
extends Thread {
    private BlockImageCreationData creationData;
    private WorldTransformAction transform;

    public BlockImageBuilder(BlockImageCreationData creationData) {
        this.creationData = creationData;
        this.start();
    }

    private void reportError(Exception e) {
        if (this.creationData.onError != null) {
            this.creationData.onError.accept(e);
        }
    }

    private void reportSuccess(WorldTransformAction transform) {
        this.creationData.onSuccess.accept(transform);
    }

    @Override
    public void run() {
        int y;
        WorldTransformCreationData transformData = new WorldTransformCreationData();
        transformData.world = this.creationData.world;
        transformData.pos = this.creationData.pos;
        transformData.xDir = this.creationData.xDir;
        transformData.yDir = this.creationData.yDir;
        transformData.zDir = this.creationData.zDir;
        transformData.w = this.creationData.blockWidth;
        transformData.h = this.creationData.blockHeight;
        transformData.d = 1;
        this.transform = new WorldTransformAction(transformData);
        int tileWidth = Math.max(this.creationData.image.width / this.creationData.blockWidth, 1);
        int tileHeight = Math.max(this.creationData.image.height / this.creationData.blockHeight, 1);
        ArrayList<ImageBlock> preSized = new ArrayList<ImageBlock>();
        for (ImageBlock block : ImageCommand.blockList) {
            preSized.add(new ImageBlock(block.blockState, ResizeableImage.resize(block.image, tileWidth, tileHeight)));
        }
        BlockImageCreationWorker[] workers = new BlockImageCreationWorker[this.creationData.blockHeight];
        for (y = 0; y < this.creationData.blockHeight; ++y) {
            workers[y] = new BlockImageCreationWorker(this.transform, this.creationData, preSized, tileWidth, tileHeight);
            workers[y].setWorkload(0, this.creationData.blockWidth, y, y + 1);
            workers[y].start();
        }
        for (y = 0; y < this.creationData.blockHeight; ++y) {
            try {
                workers[y].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.reportSuccess(this.transform);
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

