/*
 * Decompiled with CFR 0.152.
 */
package it.pierhurts.fartgen.tilentity;

import it.pierhurts.fartgen.block.BlockGenerator;
import it.pierhurts.fartgen.config.GeneralConfig;
import it.pierhurts.fartgen.utils.CustomEnergyStorage;
import it.pierhurts.fartgen.utils.Handler;
import it.pierhurts.fartgen.utils.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityGenerator
extends TileEntity
implements ITickable {
    private boolean hasEntity = false;
    private int entityIndex;
    private Entity entity;
    public CustomEnergyStorage eStorage = new CustomEnergyStorage(GeneralConfig.maxCapacity);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IEnergyStorage enStorage;
            if (!this.hasEntity) {
                List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.func_174877_v()));
                if (!list.isEmpty()) {
                    for (EntityLivingBase e : list) {
                        ResourceLocation entityKey = EntityList.func_191301_a((Entity)e);
                        for (int index = 0; index < Utils.lenght(); ++index) {
                            if (entityKey == null || !entityKey.toString().equals(Utils.getEntity(index))) continue;
                            this.entity = e;
                            e.func_70106_y();
                            this.hasEntity = true;
                            this.entityIndex = index;
                            this.updatePacket();
                        }
                    }
                }
            } else {
                this.eStorage.receiveEnergy(Utils.getRFPerTick(this.entityIndex), false);
                this.updatePacket();
                if (this.eStorage.getEnergyStored() < this.eStorage.getMaxEnergyStored() && this.field_145850_b.func_82737_E() % (long)(GeneralConfig.fartPerSecond * 20) == 0L) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, Handler.entity_fartgen_loudfart, SoundCategory.BLOCKS, GeneralConfig.fartVolume, 1.0f);
                }
            }
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            int stored = this.eStorage.getEnergyStored();
            if (tile != null && tile.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP) && (enStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)).canReceive() && enStorage.getEnergyStored() < enStorage.getMaxEnergyStored()) {
                if (stored >= GeneralConfig.maxEnergyOutput && enStorage.getMaxEnergyStored() - enStorage.getEnergyStored() >= stored) {
                    enStorage.receiveEnergy(GeneralConfig.maxEnergyOutput, false);
                    this.eStorage.extractEnergy(GeneralConfig.maxEnergyOutput, false);
                    this.updatePacket();
                } else if (enStorage.getMaxEnergyStored() - enStorage.getEnergyStored() < stored) {
                    enStorage.receiveEnergy(enStorage.getMaxEnergyStored() - enStorage.getEnergyStored(), false);
                    this.eStorage.extractEnergy(enStorage.getMaxEnergyStored() - enStorage.getEnergyStored(), false);
                    this.updatePacket();
                } else {
                    enStorage.receiveEnergy(stored, false);
                    this.eStorage.extractEnergy(stored, false);
                    this.updatePacket();
                }
            }
        }
        if (!this.hasEntity && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockGenerator.HAS_ENTITY)).booleanValue()) {
            BlockGenerator.setState(false, this.field_145850_b, this.field_174879_c);
        }
        if (this.hasEntity && !((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockGenerator.HAS_ENTITY)).booleanValue()) {
            BlockGenerator.setState(true, this.field_145850_b, this.field_174879_c);
        }
        this.updatePacket();
    }

    public void onLoad() {
        super.onLoad();
        this.updatePacket();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.isCapability(capability, facing, EnumFacing.DOWN)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void updatePacket() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.isCapability(capability, facing, EnumFacing.DOWN)) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.eStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean isCapability(Capability capability, EnumFacing facing, EnumFacing type) {
        return capability == CapabilityEnergy.ENERGY && facing == type;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeGeneratorNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readGeneratorNBT(compound);
    }

    public void writeGeneratorNBT(NBTTagCompound compound) {
        compound.func_74757_a("has_entity", this.hasEntity);
        compound.func_74768_a("entityIndex", this.entityIndex);
        compound.func_74768_a("energy", this.eStorage.getEnergyStored());
        if (this.entity != null) {
            compound.func_186854_a("entityMob", this.entity.func_110124_au());
        }
    }

    public void readGeneratorNBT(NBTTagCompound compound) {
        this.hasEntity = compound.func_74767_n("has_entity");
        this.entityIndex = compound.func_74762_e("entityIndex");
        this.eStorage.receiveEnergy(compound.func_74762_e("energy") - this.eStorage.getEnergyStored(), false);
        this.entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(Utils.getEntity(this.entityIndex)), (World)this.field_145850_b);
        if (this.entity != null) {
            this.entity.func_184221_a(compound.func_186857_a("entityMob"));
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readGeneratorNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeGeneratorNBT(tagCompound);
        tagCompound.func_74768_a("x", this.field_174879_c.func_177958_n());
        tagCompound.func_74768_a("y", this.field_174879_c.func_177956_o());
        tagCompound.func_74768_a("z", this.field_174879_c.func_177952_p());
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readGeneratorNBT(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(2.0);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public int getEntityIndex() {
        return this.entityIndex;
    }

    public boolean hasEntity() {
        return this.hasEntity;
    }
}

