/*
 * Decompiled with CFR 0.152.
 */
package it.pierhurts.fartgen.block;

import it.pierhurts.fartgen.block.ModBlocks;
import it.pierhurts.fartgen.config.GeneralConfig;
import it.pierhurts.fartgen.tilentity.TileEntityGenerator;
import it.pierhurts.fartgen.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGenerator
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool HAS_ENTITY = PropertyBool.func_177716_a((String)"has_entity");

    public BlockGenerator(String name) {
        super(Material.field_151573_f, MapColor.field_151649_A);
        this.setRegistryName("fartgen", name);
        this.func_149663_c(name);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149715_a(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HAS_ENTITY, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityGenerator) {
            TileEntityGenerator te = (TileEntityGenerator)tile;
            int stored = te.eStorage.getEnergyStored();
            int capacity = te.eStorage.getMaxEnergyStored();
            int maxOut = GeneralConfig.maxEnergyOutput;
            int generation = Utils.getRFPerTick(te.getEntityIndex());
            String msg = "\nStored : " + stored + "\n Capacity : " + capacity + "\n Max Output : " + maxOut + "\n Generating : " + generation;
            player.func_145747_a((ITextComponent)new TextComponentString(msg));
        }
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HAS_ENTITY});
    }

    public static void setState(boolean isActived, World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        TileEntity tileE = worldIn.func_175625_s(pos);
        if (isActived) {
            worldIn.func_175656_a(pos, ModBlocks.gen.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)HAS_ENTITY, (Comparable)Boolean.valueOf(true)));
        } else {
            worldIn.func_175656_a(pos, ModBlocks.gen.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)HAS_ENTITY, (Comparable)Boolean.valueOf(false)));
        }
        if (tileE != null) {
            tileE.func_145829_t();
            worldIn.func_175690_a(pos, tileE);
        }
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGenerator();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGenerator) {
            TileEntityGenerator teFartGen = (TileEntityGenerator)te;
            ItemStack teItem = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound nbt = new NBTTagCompound();
            teFartGen.writeGeneratorNBT(nbt);
            teItem.func_77982_d(nbt);
            l.add(teItem);
        }
        return l;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGenerator && !player.func_184812_l_()) {
            TileEntityGenerator teFartGen = (TileEntityGenerator)te;
            ItemStack teItem = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound nbt = new NBTTagCompound();
            teFartGen.writeGeneratorNBT(nbt);
            teItem.func_77982_d(nbt);
            BlockGenerator.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)teItem);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.45, 1.0);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGenerator) {
            TileEntityGenerator teFartGen = (TileEntityGenerator)te;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                teFartGen.readGeneratorNBT(tag);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.localizeTooltip("tooltip.fartgen.tum"));
    }

    private String localizeTooltip(String ... unlocalized) {
        String str = "";
        for (String s : unlocalized) {
            str = str + new TextComponentTranslation(s, new Object[0]).func_150254_d();
        }
        return str;
    }
}

