/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.function.Function;
import pl.asie.stackup.script.ScriptHandler;
import pl.asie.stackup.script.Token;
import pl.asie.stackup.script.TokenException;

public class TokenNumeric<T>
extends Token<T> {
    protected final Function<T, Number> function;
    private Token.ComparisonType type;
    private int number;

    public TokenNumeric(Function<T, Number> function) {
        this.function = function;
    }

    protected boolean isInvalidComparisonType(Token.ComparisonType type) {
        return type != Token.ComparisonType.EQUAL && type != Token.ComparisonType.LESS_EQUAL && type != Token.ComparisonType.NOT_EQUAL && type != Token.ComparisonType.LESS_THAN && type != Token.ComparisonType.GREATER_EQUAL && type != Token.ComparisonType.GREATER_THAN;
    }

    public static int parseInteger(PushbackReader reader) throws NumberFormatException, IOException {
        int c;
        StringBuilder builder = new StringBuilder();
        ScriptHandler.cutWhitespace(reader);
        while (Character.isDigit(c = reader.read())) {
            builder.appendCodePoint(c);
        }
        reader.unread(c);
        ScriptHandler.cutWhitespace(reader);
        return Integer.parseInt(builder.toString());
    }

    @Override
    public void parse(PushbackReader reader) throws IOException, TokenException {
        this.type = this.getComparisonType(reader);
        if (this.isInvalidComparisonType(this.type)) {
            throw new TokenException("Unsupported comparison type " + (Object)((Object)this.type) + "!");
        }
        try {
            this.number = TokenNumeric.parseInteger(reader);
        }
        catch (NumberFormatException e) {
            throw new TokenException("Invalid number!", e);
        }
    }

    protected int getNumber() {
        return this.number;
    }

    protected Token.ComparisonType getComparisonType() {
        return this.type;
    }

    @Override
    public boolean apply(T object) {
        Number n = this.function.apply(object);
        int iv = n.intValue();
        switch (this.type) {
            default: {
                return iv == this.number;
            }
            case NOT_EQUAL: {
                return iv != this.number;
            }
            case LESS_THAN: {
                return iv < this.number;
            }
            case GREATER_THAN: {
                return iv > this.number;
            }
            case LESS_EQUAL: {
                return iv <= this.number;
            }
            case GREATER_EQUAL: 
        }
        return iv >= this.number;
    }
}

