/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script;

import com.google.common.collect.Ordering;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import pl.asie.stackup.StackUp;
import pl.asie.stackup.script.ScriptContext;
import pl.asie.stackup.script.TokenProvider;

public class ScriptHandler {
    protected static void cutWhitespace(PushbackReader r) throws IOException {
        int c;
        while (Character.isWhitespace(c = r.read())) {
        }
        r.unread(c);
    }

    protected void processFile(IForgeRegistry<Item> registry, File file) {
        StackUp.logger.info("Parsing " + file.getName());
        try (FileInputStream stream = new FileInputStream(file);){
            new ScriptContext(registry, stream, TokenProvider.INSTANCE).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void processDirectory(IForgeRegistry<Item> registry, File file) {
        TreeSet<File> files = new TreeSet<File>((Comparator<File>)Ordering.natural());
        for (File f : Objects.requireNonNull(file.listFiles())) {
            files.add(f);
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.processDirectory(registry, f);
                continue;
            }
            this.processFile(registry, f);
        }
    }

    public void process(IForgeRegistry<Item> registry, File baseDir) {
        if (baseDir == null || !baseDir.exists() || !baseDir.isDirectory()) {
            return;
        }
        this.processDirectory(registry, baseDir);
    }
}

