/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script;

import com.google.common.base.Charsets;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.stackup.StackUp;
import pl.asie.stackup.StackUpHelpers;
import pl.asie.stackup.script.ScriptHandler;
import pl.asie.stackup.script.Token;
import pl.asie.stackup.script.TokenException;
import pl.asie.stackup.script.TokenNumeric;
import pl.asie.stackup.script.TokenProvider;

public class ScriptContext {
    private final IForgeRegistry<Item> registry;
    private final TokenProvider tokenProvider;
    private final InputStreamReader streamReader;
    private final BufferedReader reader;
    private final TObjectIntMap<Item> stackSizeMap;

    public ScriptContext(IForgeRegistry<Item> registry, InputStream stream, TokenProvider provider) {
        this.registry = registry;
        this.tokenProvider = provider;
        this.streamReader = new InputStreamReader(stream, Charsets.UTF_8);
        this.reader = new BufferedReader(this.streamReader);
        this.stackSizeMap = new TObjectIntHashMap();
        provider.addToken("size", () -> new TokenNumeric<Item>(item -> this.getStackSize((Item)item, false)));
    }

    public void execute() {
        int parsed = 0;
        try {
            Iterator it = this.reader.lines().iterator();
            while (it.hasNext()) {
                this.parseLine((String)it.next());
                ++parsed;
            }
            this.reader.close();
            this.streamReader.close();
        }
        catch (IOException | TokenException e) {
            e.printStackTrace();
        }
        StackUp.logger.info("Parsed " + parsed + " lines.");
        this.applyChanges();
    }

    protected void parseLine(String line) throws IOException, TokenException {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        if (line.startsWith("#")) {
            return;
        }
        PushbackReader reader = new PushbackReader(new StringReader(line), 2);
        ArrayList<Object> args = new ArrayList<Object>();
        int newStackSize = 0;
        int operator = 61;
        int i = 256;
        while (i-- > 0) {
            Pair<String, Token> token;
            if (i < 256) {
                ScriptHandler.cutWhitespace(reader);
                int c = reader.read();
                if (c != 44) {
                    reader.unread(c);
                } else {
                    ScriptHandler.cutWhitespace(reader);
                }
            }
            if ((token = this.tokenProvider.getToken(reader)).getRight() == null) {
                int c2;
                int c1 = reader.read();
                if (c1 == 45) {
                    c2 = reader.read();
                    if (c2 == 62) {
                        newStackSize = TokenNumeric.parseInteger(reader);
                        break;
                    }
                    if (c2 == 61) {
                        newStackSize = TokenNumeric.parseInteger(reader);
                        operator = c1;
                        break;
                    }
                    reader.unread(c2);
                } else if (c1 == 43 || c1 == 42 || c1 == 47) {
                    c2 = reader.read();
                    if (c2 == 61) {
                        newStackSize = TokenNumeric.parseInteger(reader);
                        operator = c1;
                        break;
                    }
                    reader.unread(c2);
                } else {
                    reader.unread(c1);
                }
                throw new TokenException("Token not found: " + (String)token.getLeft() + "!");
            }
            ((Token)token.getRight()).parse(reader);
            args.add(token.getRight());
        }
        if (newStackSize > 0) {
            for (Item item : this.registry) {
                boolean ok = true;
                for (Token t : args) {
                    if (t.isInvert()) {
                        if (!t.apply(item)) continue;
                        ok = false;
                        break;
                    }
                    if (t.apply(item)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                switch (operator) {
                    case 61: {
                        this.stackSizeMap.put((Object)item, this.clamp(newStackSize));
                        break;
                    }
                    case 43: {
                        this.stackSizeMap.put((Object)item, this.clamp(this.getStackSize(item, true) + newStackSize));
                        break;
                    }
                    case 45: {
                        this.stackSizeMap.put((Object)item, this.clamp(this.getStackSize(item, true) - newStackSize));
                        break;
                    }
                    case 42: {
                        this.stackSizeMap.put((Object)item, this.clamp(this.getStackSize(item, true) * newStackSize));
                        break;
                    }
                    case 47: {
                        this.stackSizeMap.put((Object)item, this.clamp(this.getStackSize(item, true) / newStackSize));
                    }
                }
            }
        }
    }

    protected int clamp(int v) {
        if (v < 1) {
            return 1;
        }
        if (v > StackUpHelpers.getMaxStackSize()) {
            return StackUpHelpers.getMaxStackSize();
        }
        return v;
    }

    protected int getStackSize(Item i, boolean withMap) {
        if (withMap && this.stackSizeMap.containsKey((Object)i)) {
            return this.stackSizeMap.get((Object)i);
        }
        return i.func_77639_j();
    }

    protected void applyChanges() {
        for (Item i : this.stackSizeMap.keySet()) {
            if (i == Items.field_190931_a) continue;
            int target = this.stackSizeMap.get((Object)i);
            StackUp.backupStackSize(i);
            i.func_77625_d(target);
            int result = i.func_77639_j();
            if (target == result) continue;
            StackUp.logger.warn("Could not change stack size on item " + i.getRegistryName() + "!");
        }
        this.stackSizeMap.clear();
    }
}

