/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;

public class StackUpClassTracker {
    private static final Map<String, String> superclassMap = new HashMap<String, String>();
    private static final Multimap<String, String> interfaceMap = HashMultimap.create();

    public static void addClass(String currC) {
        if (!superclassMap.containsKey(currC)) {
            String filename = FMLDeobfuscatingRemapper.INSTANCE.unmap(currC.replace('.', '/'));
            filename = filename.replace('.', '/') + ".class";
            InputStream stream = StackUpClassTracker.class.getClassLoader().getResourceAsStream(filename);
            if (stream != null) {
                try {
                    ClassReader reader = new ClassReader(stream);
                    String newC = reader.getSuperName();
                    if (newC != null) {
                        newC = FMLDeobfuscatingRemapper.INSTANCE.map(newC).replace('/', '.');
                        superclassMap.put(currC, newC);
                    }
                    for (String s : reader.getInterfaces()) {
                        String newI = FMLDeobfuscatingRemapper.INSTANCE.map(s).replace('/', '.');
                        interfaceMap.put((Object)currC, (Object)newI);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    superclassMap.put(currC, null);
                }
            }
        }
    }

    public static boolean isImplements(String c, String sc) {
        String currC = c;
        while (currC != null && currC.length() > 0) {
            if (currC.equals(sc)) {
                return true;
            }
            StackUpClassTracker.addClass(currC);
            for (String s : interfaceMap.get((Object)currC)) {
                if (!StackUpClassTracker.isImplements(s, sc)) continue;
                return true;
            }
            currC = superclassMap.get(currC);
        }
        return false;
    }

    public static boolean isExtends(String c, String sc) {
        String currC = c;
        while (currC != null && currC.length() > 0) {
            if (currC.equals(sc)) {
                return true;
            }
            StackUpClassTracker.addClass(currC);
            currC = superclassMap.get(currC);
        }
        return false;
    }
}

