/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.core;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class MaxStackConstantPatch {
    private MaxStackConstantPatch() {
    }

    public static Consumer<ClassNode> patchMaxLimit(String ... methods) {
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        return node -> {
            for (MethodNode mn : node.methods) {
                if (!methodSet.contains(mn.name)) continue;
                int patchesMade = 0;
                ListIterator it = mn.instructions.iterator();
                while (it.hasNext()) {
                    AbstractInsnNode in = (AbstractInsnNode)it.next();
                    if (in.getOpcode() != 16) continue;
                    IntInsnNode iin = (IntInsnNode)in;
                    if (iin.operand != 64) continue;
                    System.out.println("Patched max stack check in " + node.name + " -> " + mn.name + "!");
                    it.set(new MethodInsnNode(184, "pl/asie/stackup/StackUpHelpers", "getMaxStackSize", "()I", false));
                    ++patchesMade;
                }
                if (patchesMade <= true) continue;
                System.out.println("NOTE: Made " + patchesMade + " patches in " + node.name + " -> " + mn.name + "!");
            }
        };
    }
}

