/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.client;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import pl.asie.stackup.StackUpConfig;
import pl.asie.stackup.client.StackUpTextGenerator;

public final class StackUpClientHelpers {
    public static final int SLOT_MAX_WIDTH = 16;

    private StackUpClientHelpers() {
    }

    public static int getModelCount(ItemStack stack) {
        if (stack.func_190916_E() > 2) {
            return MathHelper.func_151241_e((int)stack.func_190916_E());
        }
        return stack.func_190916_E();
    }

    public static float getItemRenderDistanceNeg(EntityItem item) {
        return -StackUpClientHelpers.getItemRenderDistance(item);
    }

    public static float getItemRenderDistance(EntityItem item) {
        int mc = StackUpClientHelpers.getModelCount(item.func_92059_d());
        if (mc <= 2) {
            return 0.09375f;
        }
        return 0.125f / MathHelper.func_76129_c((float)(mc - 1));
    }

    public static int drawItemCountWithShadow(FontRenderer fr, String text, float x, float y, int color) {
        if (text.length() == 0) {
            return 0;
        }
        if (StackUpConfig.highestScaleDown >= 1.0f && StackUpTextGenerator.getStringLenWithoutFmtCodes(text) <= 2) {
            return fr.func_175063_a(text, x, y, color);
        }
        float xOffset = 17 - fr.func_78256_a(text);
        float yOffset = 9.0f;
        x -= xOffset;
        y -= yOffset;
        StackUpTextGenerator.AbbreviationResult result = StackUpTextGenerator.abbreviate(fr, text, 16, false);
        float scaleDiff = result.getScaleFactor();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x += 16.0f - (float)fr.func_78256_a(result.getText()) * scaleDiff), (float)(y += 16.0f - 8.0f * scaleDiff), (float)0.0f);
        GlStateManager.func_179152_a((float)scaleDiff, (float)scaleDiff, (float)1.0f);
        GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        int i = fr.func_175063_a(result.getText(), x, y, color);
        GlStateManager.func_179121_F();
        return i;
    }
}

