/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage.model;

import com.eerussianguy.betterfoliage.BFConfig;
import com.eerussianguy.betterfoliage.Helpers;
import com.eerussianguy.betterfoliage.model.LeavesOrdinalData;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LeavesBakedModel
implements IDynamicBakedModel {
    public static List<LeavesBakedModel> INSTANCES = new ArrayList<LeavesBakedModel>();
    private final ResourceLocation leaves;
    private final ResourceLocation fluff;
    private final ResourceLocation overlay;
    private final ResourceLocation modelLocation;
    private final boolean isOverlay;
    private final boolean tintOverlay;
    private final boolean tintLeaves;
    private TextureAtlasSprite leavesTex;
    private TextureAtlasSprite fluffTex;
    private final BlockModel blockModel;
    private final IBakedModel[] crosses;
    private IBakedModel core;
    private IBakedModel outerCore;

    public LeavesBakedModel(ResourceLocation modelLocation, ResourceLocation leaves, ResourceLocation fluff, ResourceLocation overlay, boolean tintLeaves, boolean tintOverlay) {
        this.crosses = new IBakedModel[(int)Math.pow(((Integer)BFConfig.CLIENT.leavesCacheSize.get()).intValue(), 3.0)];
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), false, BlockModel.GuiLight.FRONT, ItemCameraTransforms.field_178357_a, (List)ItemOverrideList.field_188022_a.getOverrides());
        this.modelLocation = modelLocation;
        this.leaves = leaves;
        this.fluff = fluff;
        this.overlay = overlay;
        this.isOverlay = !overlay.equals((Object)Helpers.EMPTY);
        this.tintLeaves = tintLeaves;
        this.tintOverlay = tintOverlay;
        INSTANCES.add(this);
    }

    public void init() {
        this.leavesTex = Helpers.getTexture(this.leaves);
        this.fluffTex = Helpers.getTexture(this.fluff);
        if (this.isOverlay) {
            TextureAtlasSprite overlayTex = Helpers.getTexture(this.overlay);
            this.outerCore = this.buildBlock(overlayTex, this.tintOverlay);
        }
        this.core = this.buildBlock(this.leavesTex, this.tintLeaves);
        this.buildCrosses();
    }

    private void buildCrosses() {
        float[] intervals;
        int ordinal = 0;
        float leavesVariationDistance = ((Double)BFConfig.CLIENT.leavesVariationDistance.get()).floatValue();
        for (float x : intervals = Helpers.intervals((Integer)BFConfig.CLIENT.leavesCacheSize.get(), -leavesVariationDistance, leavesVariationDistance)) {
            for (float y : intervals) {
                for (float z : intervals) {
                    this.buildCross(ordinal, x, y, z);
                    ++ordinal;
                }
            }
        }
    }

    private void buildCross(int ordinal, float x, float y, float z) {
        BlockFaceUV uv = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        mapFacesIn.put(Direction.NORTH, Helpers.makeTintedFace(uv));
        mapFacesIn.put(Direction.SOUTH, Helpers.makeTintedFace(uv));
        Vector3f from = new Vector3f(-8.0f, -8.0f, 8.0f);
        Vector3f to = new Vector3f(24.0f, 24.0f, 8.0f);
        Vector3f moveVec = new Vector3f(x / 2.0f, y / 1.2f, z / 2.0f);
        from.func_229189_a_(moveVec);
        to.func_229189_a_(moveVec);
        BlockPart part = new BlockPart(from, to, (Map)mapFacesIn, this.makeRotation(45.0f), false);
        BlockPart partR = new BlockPart(from, to, (Map)mapFacesIn, this.makeRotation(-45.0f), false);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrideList.field_188022_a, false).func_177646_a(this.leavesTex);
        Helpers.assembleFaces(builder, part, this.fluffTex, this.modelLocation);
        Helpers.assembleFaces(builder, partR, this.fluffTex, this.modelLocation);
        this.crosses[ordinal] = builder.func_177645_b();
    }

    private BlockPartRotation makeRotation(float degrees) {
        return new BlockPartRotation(new Vector3f(0.5f, 0.0f, 0.5f), Direction.Axis.Y, degrees, false);
    }

    private IBakedModel buildBlock(TextureAtlasSprite tex, boolean tint) {
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction d : Helpers.DIRECTIONS) {
            BlockFaceUV faceUV = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
            mapFacesIn.put(d, tint ? Helpers.makeTintedFace(faceUV) : Helpers.makeFace(faceUV));
        }
        BlockPart part = new BlockPart(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrideList.field_188022_a, false).func_177646_a(tex);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction d = (Direction)e.getKey();
            builder.func_177650_a(d, Helpers.makeBakedQuad(part, (BlockPartFace)e.getValue(), tex, d, ModelRotation.X0_Y0, this.modelLocation));
        }
        return builder.func_177645_b();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        List coreQuads = this.core.getQuads(state, side, rand, extraData);
        if (state == null) {
            return coreQuads;
        }
        LeavesOrdinalData data = extraData instanceof LeavesOrdinalData ? (LeavesOrdinalData)extraData : new LeavesOrdinalData();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(coreQuads);
        List crossQuads = this.crosses[data.get()].getQuads(state, side, rand, extraData);
        quads.addAll(crossQuads);
        if (this.isOverlay) {
            List outQuads = this.outerCore.getQuads(state, side, rand, extraData);
            quads.addAll(outQuads);
        }
        return quads;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData extraData) {
        return new LeavesOrdinalData(pos);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.leavesTex;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

