/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage.model;

import com.eerussianguy.betterfoliage.Helpers;
import com.eerussianguy.betterfoliage.model.GrassConnectionData;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GrassBakedModel
implements IDynamicBakedModel {
    public static List<GrassBakedModel> INSTANCES = new ArrayList<GrassBakedModel>();
    private final BlockModel blockModel;
    private final ResourceLocation modelLocation;
    private final ResourceLocation dirt;
    private final ResourceLocation top;
    private final ResourceLocation overlay;
    private final boolean tint;
    private TextureAtlasSprite dirtTex;
    private TextureAtlasSprite topTex;
    private TextureAtlasSprite overlayTex;
    private final IBakedModel[] models = new IBakedModel[16];
    private BlockPart core;

    public GrassBakedModel(ResourceLocation modelLocation, ResourceLocation dirt, ResourceLocation top, ResourceLocation overlay, boolean tint) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), false, BlockModel.GuiLight.FRONT, ItemCameraTransforms.field_178357_a, (List)ItemOverrideList.field_188022_a.getOverrides());
        this.modelLocation = modelLocation;
        this.dirt = dirt;
        this.top = top;
        this.overlay = overlay;
        this.tint = tint;
        INSTANCES.add(this);
    }

    public void init() {
        this.dirtTex = Helpers.getTexture(this.dirt);
        this.topTex = Helpers.getTexture(this.top);
        this.overlayTex = Helpers.getTexture(this.overlay);
        this.buildCore();
        this.generateModels();
    }

    public void buildCore() {
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction d : Helpers.DIRECTIONS) {
            BlockFaceUV faceUV = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
            mapFacesIn.put(d, d == Direction.UP && this.tint ? Helpers.makeTintedFace(faceUV) : Helpers.makeFace(faceUV));
        }
        this.core = new BlockPart(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)mapFacesIn, null, true);
    }

    public void generateModels() {
        for (int meta = 0; meta < 16; ++meta) {
            Direction d;
            EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
            for (Direction d2 : Helpers.DIRECTIONS) {
                BlockFaceUV faceUV = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
                mapFacesIn.put(d2, d2 != Direction.DOWN && this.tint ? Helpers.makeTintedFace(faceUV) : Helpers.makeFace(faceUV));
            }
            BlockPart part = new BlockPart(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)mapFacesIn, null, true);
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrideList.field_188022_a, false).func_177646_a(this.topTex);
            for (Map.Entry e : this.core.field_178240_c.entrySet()) {
                d = (Direction)e.getKey();
                builder.func_177650_a(d, Helpers.makeBakedQuad(this.core, (BlockPartFace)e.getValue(), d == Direction.UP ? this.topTex : this.dirtTex, d, ModelRotation.X0_Y0, this.modelLocation));
            }
            for (Map.Entry e : part.field_178240_c.entrySet()) {
                d = (Direction)e.getKey();
                builder.func_177650_a(d, Helpers.makeBakedQuad(part, (BlockPartFace)e.getValue(), this.resolveTexture(d, GrassBakedModel.stateFromMeta(meta)), d, ModelRotation.X0_Y0, this.modelLocation));
            }
            this.models[meta] = builder.func_177645_b();
        }
    }

    private TextureAtlasSprite resolveTexture(Direction d, boolean[] booleans) {
        switch (d) {
            case UP: {
                return this.topTex;
            }
            default: {
                return this.dirtTex;
            }
            case NORTH: {
                return booleans[0] ? this.topTex : this.overlayTex;
            }
            case EAST: {
                return booleans[1] ? this.topTex : this.overlayTex;
            }
            case SOUTH: {
                return booleans[2] ? this.topTex : this.overlayTex;
            }
            case WEST: 
        }
        return booleans[3] ? this.topTex : this.overlayTex;
    }

    private static boolean[] stateFromMeta(int meta) {
        boolean[] state = new boolean[]{false, false, false, false};
        state[0] = (meta & 1) > 0;
        state[1] = (meta & 2) > 0;
        state[2] = (meta & 4) > 0;
        state[3] = (meta & 8) > 0;
        return state;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        int meta = state != null && extraData instanceof GrassConnectionData ? ((GrassConnectionData)extraData).get() : 0;
        return this.models[meta].getQuads(state, side, rand, extraData);
    }

    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData extraData) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        BlockPos down = pos.func_177977_b();
        boolean north = world.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)down, Direction.NORTH)).func_235901_b_((Property)BlockStateProperties.field_208196_w);
        boolean east = world.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)down, Direction.EAST)).func_235901_b_((Property)BlockStateProperties.field_208196_w);
        boolean south = world.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)down, Direction.SOUTH)).func_235901_b_((Property)BlockStateProperties.field_208196_w);
        boolean west = world.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)down, Direction.WEST)).func_235901_b_((Property)BlockStateProperties.field_208196_w);
        return new GrassConnectionData(north, east, south, west);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.dirtTex;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

