/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class Helpers {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final ResourceLocation EMPTY = new ResourceLocation("betterfoliage", "empty");

    public static BlockPartFace makeTintedFace(BlockFaceUV uv) {
        return new BlockPartFace(null, 0, "", uv);
    }

    public static BlockPartFace makeFace(BlockFaceUV uv) {
        return new BlockPartFace(null, -1, "", uv);
    }

    public static BakedQuad makeBakedQuad(BlockPart blockPart, BlockPartFace partFace, TextureAtlasSprite atlasSprite, Direction dir, ModelRotation modelRotation, ResourceLocation modelResLoc) {
        return new FaceBakery().func_228824_a_(blockPart.field_178241_a, blockPart.field_178239_b, partFace, atlasSprite, dir, (IModelTransform)modelRotation, blockPart.field_178237_d, true, modelResLoc);
    }

    public static void assembleFaces(SimpleBakedModel.Builder builder, BlockPart part, TextureAtlasSprite sprite, ResourceLocation modelLocation) {
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction d = (Direction)e.getKey();
            builder.func_177650_a(d, Helpers.makeBakedQuad(part, (BlockPartFace)e.getValue(), sprite, d, ModelRotation.X0_Y0, modelLocation));
        }
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(location);
    }

    public static float[] intervals(int n, float min, float max) {
        float[] f = new float[n];
        for (int i = 0; i < n; ++i) {
            float t = (float)i / (float)(n - 1);
            f[i] = min * t + max * (1.0f - t);
        }
        return f;
    }
}

