/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage;

import com.eerussianguy.betterfoliage.BFConfig;
import com.eerussianguy.betterfoliage.ClientEventHandler;
import com.eerussianguy.betterfoliage.ParticleLocation;
import com.eerussianguy.betterfoliage.particle.LeafParticle;
import com.eerussianguy.betterfoliage.particle.SoulParticle;
import com.eerussianguy.betterfoliage.particle.SpritePicker;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterfoliage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientForgeEventHandler {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        Entity entity = mc.func_175606_aa();
        if (entity == null) {
            return;
        }
        ClientWorld world = (ClientWorld)entity.field_70170_p;
        if (world == null || world.func_82737_E() % 2L != 0L) {
            return;
        }
        Vector3d pos = entity.func_213303_ch();
        Random rand = world.field_73012_v;
        int spawnDistance = (Integer)BFConfig.CLIENT.particleDistance.get();
        for (int i = 0; i < (Integer)BFConfig.CLIENT.particleAttempts.get(); ++i) {
            SpriteTexturedParticle particle;
            BlockPos searchPos = new BlockPos(pos.func_72441_c((double)(rand.nextInt(spawnDistance) - rand.nextInt(spawnDistance)), (double)(rand.nextInt(spawnDistance) - 1), (double)(rand.nextInt(spawnDistance) - rand.nextInt(spawnDistance))));
            BlockState state = world.func_180495_p(searchPos);
            if (state.func_235714_a_((ITag)BlockTags.field_206952_E) && world.func_175623_d(searchPos.func_177977_b())) {
                particle = new LeafParticle(world, (double)searchPos.func_177958_n() + 0.5, (double)searchPos.func_177956_o() - 1.0, (double)searchPos.func_177952_p() + 0.5);
                if (((Boolean)BFConfig.CLIENT.snowballs.get()).booleanValue() && rand.nextInt(2) == 0 && world.func_180495_p(searchPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)) {
                    ClientForgeEventHandler.addParticle(particle, ClientEventHandler.MAP.get((Object)ParticleLocation.SNOWBALL));
                    continue;
                }
                if (!((Boolean)BFConfig.CLIENT.leaves.get()).booleanValue()) continue;
                world.func_242406_i(searchPos).ifPresent(arg_0 -> ClientForgeEventHandler.lambda$onClientTick$0((LeafParticle)particle, state, world, searchPos, arg_0));
                continue;
            }
            if (!((Boolean)BFConfig.CLIENT.souls.get()).booleanValue() || !state.func_235714_a_((ITag)BlockTags.field_232880_av_) || !world.func_175623_d(searchPos.func_177984_a())) continue;
            particle = new SoulParticle(world, (double)searchPos.func_177958_n() + 0.5, (double)searchPos.func_177956_o() + 1.0, (double)searchPos.func_177952_p() + 0.5);
            ClientForgeEventHandler.addParticle(particle, ClientEventHandler.MAP.get((Object)ParticleLocation.SOUL));
        }
    }

    public static void addParticle(SpriteTexturedParticle particle, List<TextureAtlasSprite> sprites) {
        Minecraft mc = Minecraft.func_71410_x();
        SpritePicker picker = new SpritePicker();
        picker.rebind(sprites);
        particle.func_217568_a((IAnimatedSprite)picker);
        mc.field_71452_i.func_78873_a((Particle)particle);
    }

    public static void addTintedParticle(SpriteTexturedParticle particle, List<TextureAtlasSprite> sprites, BlockState state, ClientWorld world, BlockPos pos) {
        Minecraft mc = Minecraft.func_71410_x();
        SpritePicker picker = new SpritePicker();
        picker.rebind(sprites);
        int color = mc.func_184125_al().func_189991_a(state, (World)world, pos);
        if (color == FoliageColors.func_77468_c()) {
            color = world.func_226691_t_(pos).func_225527_a_();
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        particle.func_217568_a((IAnimatedSprite)picker);
        particle.func_70538_b(r, g, b);
        mc.field_71452_i.func_78873_a((Particle)particle);
    }

    private static /* synthetic */ void lambda$onClientTick$0(LeafParticle particle, BlockState state, ClientWorld world, BlockPos searchPos, RegistryKey key) {
        if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            ClientForgeEventHandler.addTintedParticle(particle, ClientEventHandler.MAP.get((Object)ParticleLocation.LEAF_SPRUCE), state, world, searchPos);
        } else if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            ClientForgeEventHandler.addTintedParticle(particle, ClientEventHandler.MAP.get((Object)ParticleLocation.LEAF_JUNGLE), state, world, searchPos);
        } else {
            ClientForgeEventHandler.addTintedParticle(particle, ClientEventHandler.MAP.get((Object)ParticleLocation.LEAF), state, world, searchPos);
        }
    }
}

