/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage;

import com.eerussianguy.betterfoliage.ParticleLocation;
import com.eerussianguy.betterfoliage.model.GrassBakedModel;
import com.eerussianguy.betterfoliage.model.GrassLoader;
import com.eerussianguy.betterfoliage.model.LeavesBakedModel;
import com.eerussianguy.betterfoliage.model.LeavesLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterfoliage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEventHandler {
    public static final Map<ParticleLocation, List<TextureAtlasSprite>> MAP = new HashMap<ParticleLocation, List<TextureAtlasSprite>>();

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        LeavesBakedModel.INSTANCES.forEach(LeavesBakedModel::init);
        GrassBakedModel.INSTANCES.forEach(GrassBakedModel::init);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("betterfoliage", "leaves"), (IModelLoader)new LeavesLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("betterfoliage", "grass"), (IModelLoader)new GrassLoader());
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        AtlasTexture map = event.getMap();
        ResourceLocation location = map.func_229223_g_();
        if (location.equals((Object)AtlasTexture.field_215262_g)) {
            for (String[] array : ParticleLocation.getAllLocations()) {
                for (String s : array) {
                    event.addSprite(new ResourceLocation("betterfoliage", "particle/" + s));
                }
            }
        }
    }

    @SubscribeEvent
    public static void afterTextureStitch(TextureStitchEvent.Post event) {
        AtlasTexture atlas = event.getMap();
        ResourceLocation res = atlas.func_229223_g_();
        if (res.equals((Object)AtlasTexture.field_215262_g)) {
            for (ParticleLocation location : ParticleLocation.values()) {
                MAP.put(location, ClientEventHandler.getList(atlas, location.getLocations()));
            }
        }
    }

    private static List<TextureAtlasSprite> getList(AtlasTexture atlas, String ... locations) {
        ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
        for (String s : locations) {
            list.add(atlas.func_195424_a(new ResourceLocation("betterfoliage", "particle/" + s)));
        }
        return list;
    }
}

