/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public final ForgeConfigSpec.IntValue particleAttempts;
    public final ForgeConfigSpec.IntValue particleDistance;
    public final ForgeConfigSpec.BooleanValue souls;
    public final ForgeConfigSpec.BooleanValue leaves;
    public final ForgeConfigSpec.BooleanValue snowballs;
    public final ForgeConfigSpec.IntValue leavesCacheSize;
    public final ForgeConfigSpec.DoubleValue leavesVariationDistance;
    public final ForgeConfigSpec.BooleanValue forceForgeLighting;

    ClientConfig(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("betterfoliage.config.server." + name);
        innerBuilder.push("general");
        this.particleAttempts = builder.apply("particleAttempts").comment("Attempts per tick to spawn a particle").defineInRange("particleAttempts", 2, 0, Integer.MAX_VALUE);
        this.particleDistance = builder.apply("particleDistance").comment("Horizontal and Vertical distance particles will spawn from").defineInRange("particleDistance", 15, 0, Integer.MAX_VALUE);
        this.souls = builder.apply("souls").comment("Enable Souls?").define("souls", true);
        this.leaves = builder.apply("leaves").comment("Enable Leaves?").define("leaves", true);
        this.snowballs = builder.apply("snowballs").comment("Enable Snowballs?").define("snowballs", true);
        this.leavesCacheSize = builder.apply("leavesCacheSize").comment("Determines the size of the leaves cache. Number of models cached per leaf block will be the number you input to the third power. Bigger cache = more RAM, but more variation and less z-fighting as a result").worldRestart().defineInRange("leavesCacheSize", 7, 5, 20);
        this.leavesVariationDistance = builder.apply("leavesVariationDistance").comment("Determines the max distance leaves block fluff can deviate from the actual block. 0.0 means no distance variation (all fluff is in the middle of the block)").worldRestart().defineInRange("leavesVariationDistance", 2.75, 0.0, 7.0);
        this.forceForgeLighting = builder.apply("forceForgeLighting").comment("Force Forge Lighting Pipeline? (should be true when not using Optifine)").define("forceForgeLighting", true);
        innerBuilder.pop();
    }
}

