/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.ratsmischief.common.entity;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import ladysnake.ratsmischief.common.Mischief;
import ladysnake.ratsmischief.common.entity.ai.ChaseForFunGoal;
import ladysnake.ratsmischief.common.entity.ai.EatToHealGoal;
import ladysnake.ratsmischief.common.entity.ai.FollowOwnerRatGoal;
import ladysnake.ratsmischief.common.item.RatPouchItem;
import ladysnake.ratsmischief.common.item.RatStaffItem;
import ladysnake.ratsmischief.common.network.Packets;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1330;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1429;
import net.minecraft.class_1451;
import net.minecraft.class_1496;
import net.minecraft.class_1510;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4801;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RatEntity
extends class_1321
implements IAnimatable,
class_5354 {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final class_2940<String> TYPE = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> COLOR = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> EATING = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ANGER_TIME = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13327);
    private static final class_4801 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private UUID targetUuid;
    private static final class_2940<Boolean> SNIFFING = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ROCKET_TIME = class_2945.method_12791(RatEntity.class, (class_2941)class_2943.field_13327);
    public static final Predicate<class_1542> PICKABLE_DROP_FILTER = itemEntity -> !itemEntity.method_6977() && itemEntity.method_5805();
    public static final int SPAWN_RADIUS = 100;
    public class_1352 action;
    public int actionTimer = 0;
    public class_2338 circlingCenter = class_2338.field_10980;
    public class_243 targetPosition;
    public static final List<Type> NATURAL_TYPES = ImmutableList.of((Object)((Object)Type.ALBINO), (Object)((Object)Type.BLACK), (Object)((Object)Type.GREY), (Object)((Object)Type.HUSKY), (Object)((Object)Type.CHOCOLATE), (Object)((Object)Type.LIGHT_BROWN), (Object)((Object)Type.RUSSIAN_BLUE));

    public RatEntity(class_1299<? extends class_1321> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_5985 = false;
        this.field_6013 = 2.0f;
        this.field_6207 = new RatMoveControl((class_1308)this);
        this.field_6206 = new RatLookControl((class_1308)this);
    }

    protected void method_5964(class_1266 difficulty) {
        if (!this.method_6109() && this.method_6051().nextInt(10) == 0) {
            switch (this.method_6051().nextInt(4)) {
                case 0: {
                    this.method_6122(class_1268.field_5808, new class_1799((class_1935)Mischief.HARVEST_STAFF));
                    break;
                }
                case 1: {
                    this.method_6122(class_1268.field_5808, new class_1799((class_1935)Mischief.COLLECTION_STAFF));
                    break;
                }
                case 2: {
                    this.method_6122(class_1268.field_5808, new class_1799((class_1935)Mischief.SKIRMISH_STAFF));
                    break;
                }
                case 3: {
                    this.method_6122(class_1268.field_5808, new class_1799((class_1935)Mischief.LOVE_STAFF));
                }
            }
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        this.method_5964(difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    protected void method_5693() {
        super.method_5693();
        int bound = 150;
        if (Mischief.IS_WORLD_RAT_DAY) {
            bound = 30;
        }
        if (this.field_5974.nextInt(bound) == 0) {
            this.field_6011.method_12784(TYPE, (Object)Type.GOLD.toString());
        } else {
            this.field_6011.method_12784(TYPE, (Object)RatEntity.getRandomNaturalType(this.field_5974).toString());
        }
        this.field_6011.method_12784(ANGER_TIME, (Object)0);
        this.field_6011.method_12784(SITTING, (Object)false);
        this.field_6011.method_12784(EATING, (Object)false);
        this.field_6011.method_12784(SNIFFING, (Object)false);
        this.field_6011.method_12784(COLOR, (Object)class_1767.values()[this.field_5974.nextInt(class_1767.values().length)].method_7792());
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(ROCKET_TIME, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new EatToHealGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1359((class_1308)this, 0.3f));
        this.field_6201.method_6277(3, (class_1352)new StartAttackGoal());
        this.field_6201.method_6277(4, (class_1352)new SwoopMovementGoal());
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(5, (class_1352)new PickupItemGoal());
        this.field_6201.method_6277(5, (class_1352)new BringItemToOwnerGoal(this, 1.0, 16.0f, 1.0f, false));
        this.field_6201.method_6277(6, (class_1352)new FlyWithOwnerGoal());
        this.field_6201.method_6277(6, (class_1352)new FollowOwnerRatGoal(this, 1.0, 20.0f, 2.0f, false));
        this.field_6201.method_6277(7, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, playerEntity -> this.method_29515((class_1309)playerEntity)));
        this.field_6185.method_6277(8, new ChaseForFunGoal<class_1451>((class_1308)this, class_1451.class, true));
        this.field_6185.method_6277(8, (class_1352)new class_5398((class_1308)this, true));
    }

    public static class_5132.class_5133 createEntityAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 32.0);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFlying()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.rat.fly", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.isEating()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.rat.eat", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.method_24345()) {
            this.setSniffing(false);
            this.setEating(false);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.rat.flat", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            this.setSniffing(false);
            this.setEating(false);
            if (this.getRatType() == Type.JERMA) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.rat.jermarun", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.rat.run", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        if (this.isSniffing()) {
            if (this.getRatType() == Type.RAT_KID || Mischief.IS_WORLD_RAT_DAY) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.rat.smug_dance", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.rat.sniff", Boolean.valueOf(false)));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public RatEntity createChild(class_3218 world, class_1296 entity) {
        RatEntity ratEntity = (RatEntity)Mischief.RAT.method_5883((class_1937)world);
        UUID ownerUuid = this.method_6139();
        if (ownerUuid != null) {
            ratEntity.method_6174(ownerUuid);
            ratEntity.method_6173(true);
        }
        return ratEntity;
    }

    public class_2596<?> method_18002() {
        return Packets.newSpawnPacket((class_1297)this);
    }

    public Type getRatType() {
        return Type.valueOf((String)this.field_6011.method_12789(TYPE));
    }

    public void setRatType(Type type) {
        this.field_6011.method_12778(TYPE, (Object)type.toString());
    }

    public class_1767 getRatColor() {
        return class_1767.method_7793((String)((String)this.field_6011.method_12789(COLOR)), (class_1767)class_1767.field_7952);
    }

    public void setRatColor(class_1767 color) {
        this.field_6011.method_12778(COLOR, (Object)color.method_7792());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("RatType")) {
            this.setRatType(Type.valueOf(tag.method_10558("RatType")));
        }
        this.method_29512((class_3218)this.field_6002, tag);
        if (tag.method_10545("Sitting")) {
            this.method_24346(tag.method_10577("Sitting"));
        }
        if (tag.method_10545("Color")) {
            this.setRatColor(class_1767.method_7793((String)tag.method_10558("Color"), (class_1767)class_1767.field_7952));
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10582("RatType", this.getRatType().toString());
        tag.method_10582("Color", this.getRatColor().method_7792());
        this.method_29517(tag);
        tag.method_10556("Sitting", this.method_24345());
    }

    public void method_5773() {
        super.method_5773();
        if (this.isFlying() && this.isElytrat() && this.field_6002.field_9236 && this.getRocketTime() > 0) {
            this.setRocketTime(this.getRocketTime() - 1);
            this.field_6002.method_8406((class_2394)class_2398.field_11248, this.method_23317(), this.method_23318() + 0.1, this.method_23321(), this.field_5974.nextGaussian() * 0.05, -this.method_18798().field_1351 * 0.5, this.field_5974.nextGaussian() * 0.05);
        }
        if (this.method_6059(class_1294.field_5922)) {
            class_1293 saturation = this.method_6112(class_1294.field_5922);
            this.method_6092(new class_1293(class_1294.field_5924, saturation.method_5584(), saturation.method_5578(), saturation.method_5591(), saturation.method_5581(), saturation.method_5592()));
        }
    }

    public void method_5958() {
        if (!(this.method_5968() != null || this.method_6177() != null && this.method_6177().method_6128() || !this.method_5799() && !this.method_24828())) {
            this.setFlying(false);
        }
        if (!this.method_6047().method_7960() && !this.isElytrat() && this.method_6047().method_7909() == Mischief.ELYTRAT) {
            this.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8833));
            this.method_6047().method_7934(1);
            this.method_5783(class_3417.field_14966, 1.0f, 1.2f);
        }
        if (this.field_6012 % 20 == 0 && this.method_6181() && this.method_6177() != null && !this.method_6177().method_6118(class_1304.field_6169).method_7960() && this.method_6177().method_6118(class_1304.field_6169).method_7909() == Mischief.RAT_MASK) {
            this.method_6177().method_6088().forEach((statusEffect, statusEffectInstance) -> {
                if (!this.method_6059((class_1291)statusEffect) || this.method_6112((class_1291)statusEffect) != null && this.method_6112((class_1291)statusEffect).method_5578() <= statusEffectInstance.method_5578()) {
                    this.method_6092(new class_1293(statusEffect, 60, statusEffectInstance.method_5578()));
                }
            });
        }
        if (this.method_24345() && !this.isEating() && !this.method_6118(class_1304.field_6173).method_7960()) {
            this.method_5775(this.method_6118(class_1304.field_6173));
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        if (this.method_5799()) {
            this.method_24346(false);
            this.setSniffing(false);
        }
        if (this.method_16914()) {
            if (this.method_5797().getString().equalsIgnoreCase("doctor4t")) {
                this.setRatType(Type.DOCTOR4T);
            } else if (this.method_5797().getString().equalsIgnoreCase("ratater")) {
                this.setRatType(Type.RATATER);
            } else if (this.method_5797().getString().equalsIgnoreCase("rat kid") || this.method_5797().getString().equalsIgnoreCase("hat kid")) {
                this.setRatType(Type.RAT_KID);
            } else if (this.method_5797().getString().equalsIgnoreCase("jotaro") || this.method_5797().getString().equalsIgnoreCase("jorato")) {
                this.setRatType(Type.JORATO);
            } else if (this.method_5797().getString().equalsIgnoreCase("jerma") || this.method_5797().getString().equalsIgnoreCase("jerma985")) {
                this.setRatType(Type.JERMA);
            } else if (this.method_5797().getString().equalsIgnoreCase("hollow rat") || this.method_5797().getString().equalsIgnoreCase("hollow knight")) {
                this.setRatType(Type.HOLLOW);
            } else if (this.method_5797().getString().equalsIgnoreCase("rateline") || this.method_5797().getString().equalsIgnoreCase("madeline")) {
                this.setRatType(Type.RATELINE);
            } else if (this.method_5797().getString().equalsIgnoreCase("biggie cheese")) {
                this.setRatType(Type.BIGGIE_CHEESE);
            } else if (this.method_5797().getString().equalsIgnoreCase("arathain") || this.method_5797().getString().equalsIgnoreCase("arathainfarqoe")) {
                this.setRatType(Type.ARATHAIN);
            }
        }
        if (!this.method_29511() && !this.field_6207.method_6241() && this.field_5974.nextInt(100) == 0) {
            this.setSniffing(false);
            this.setSniffing(true);
        }
        if (this.actionTimer <= 0 && this.action != null) {
            this.removeCurrentActionGoal();
        }
        if (this.action != null && this.actionTimer > 0) {
            --this.actionTimer;
        }
    }

    public boolean method_5973(class_1299<?> type) {
        return type != class_1299.field_6046;
    }

    protected void method_6050() {
        super.method_6050();
    }

    public void method_6007() {
        super.method_6007();
        if (this.isElytrat() && this.method_5968() != null && this.method_5968().method_23318() > this.method_23318() && !this.isFlying()) {
            this.method_5762(0.0, 0.5, 0.0);
            this.setFlying(true);
        }
        if (this.isEating()) {
            this.method_6125(0.0f);
        } else {
            this.method_6125(0.5f);
        }
        if (!this.field_6002.field_9236 && this.method_5936() && this.method_5805() && !this.field_6272 && !this.isEating()) {
            List list = this.field_6002.method_18467(class_1542.class, this.method_5829().method_1009(1.0, 0.0, 1.0));
            for (class_1542 itemEntity : list) {
                if (itemEntity.field_5988 || itemEntity.method_6983().method_7960() || itemEntity.method_6977() || !this.method_20820(itemEntity.method_6983())) continue;
                this.method_5949(itemEntity);
            }
        }
        if (!this.field_6002.field_9236) {
            this.method_29510((class_3218)this.field_6002, true);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.field_6002.field_9236) {
            boolean bl = this.method_6171((class_1309)player) || this.method_6181() && !this.method_6181() && !this.method_29511();
            return bl ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (itemStack.method_7909() instanceof class_1769 && this.getRatType() == Type.RAT_KID) {
            this.setRatColor(((class_1769)itemStack.method_7909()).method_7802());
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            return class_1269.field_21466;
        }
        if (this.method_6181()) {
            if (this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
                if (!player.field_7503.field_7477) {
                    itemStack.method_7934(1);
                }
                this.method_6025(item.method_19264().method_19230());
                return class_1269.field_5812;
            }
            if (this.method_6171((class_1309)player)) {
                if (player.method_5715()) {
                    if (!this.isElytrat() && item == Mischief.ELYTRAT) {
                        this.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8833));
                        if (!player.method_7337()) {
                            itemStack.method_7934(1);
                        }
                        this.method_5783(class_3417.field_14966, 1.0f, 1.2f);
                        return class_1269.field_21466;
                    }
                    if (this.isElytrat()) {
                        this.method_5775(new class_1799((class_1935)Mischief.ELYTRAT));
                        this.method_5783(class_3417.field_14966, 1.0f, 1.2f);
                        this.method_5673(class_1304.field_6174, class_1799.field_8037);
                    }
                } else if (!(item instanceof RatPouchItem || item instanceof RatStaffItem || this.method_6481(itemStack) || itemStack.method_7909() instanceof class_1769 && this.getRatType() == Type.RAT_KID)) {
                    this.method_24346(!this.method_24345());
                }
            }
        } else if (item.method_19263() && !this.method_29511()) {
            player.method_5998(hand).method_7934(1);
            if (this.field_5974.nextInt(Math.max(1, 6 - item.method_19264().method_19230())) == 0) {
                this.method_6170(player);
                this.field_6189.method_6340();
                this.method_5980(null);
                this.field_6002.method_8421((class_1297)this, (byte)7);
            } else {
                for (int i = 0; i < 7; ++i) {
                    double d = this.field_5974.nextGaussian() * 0.02;
                    double e = this.field_5974.nextGaussian() * 0.02;
                    double f = this.field_5974.nextGaussian() * 0.02;
                    ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11251, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d, e, f, 0.0);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int ticks) {
        this.field_6011.method_12778(ANGER_TIME, (Object)ticks);
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_24503(this.field_5974));
    }

    public UUID method_29508() {
        return this.targetUuid;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public boolean method_5931(class_1657 player) {
        return !this.method_29511() && super.method_5931(player);
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        if (!(target instanceof class_1548 || target instanceof class_1571 && !this.isElytrat())) {
            if (target instanceof RatEntity) {
                RatEntity ratEntity = (RatEntity)target;
                return !ratEntity.method_6181() || ratEntity.method_6177() != owner;
            }
            if (target instanceof class_1657 && owner instanceof class_1657 && !((class_1657)owner).method_7256((class_1657)target)) {
                return false;
            }
            if (target instanceof class_1496 && ((class_1496)target).method_6727()) {
                return false;
            }
            return !(target instanceof class_1321) || !((class_1321)target).method_6181();
        }
        return false;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909().method_19263();
    }

    public boolean method_6121(class_1297 target) {
        target.field_6008 = 0;
        return super.method_6121(target);
    }

    public boolean method_24345() {
        return (Boolean)this.field_6011.method_12789(SITTING) != false || (Boolean)this.field_6011.method_12789(EATING) != false;
    }

    public void method_24346(boolean sitting) {
        this.field_6011.method_12778(SITTING, (Object)sitting);
    }

    public boolean isSniffing() {
        return (Boolean)this.field_6011.method_12789(SNIFFING);
    }

    public void setSniffing(boolean sniffing) {
        this.field_6011.method_12778(SNIFFING, (Object)sniffing);
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(EATING);
    }

    public void setEating(boolean eating) {
        this.field_6011.method_12778(EATING, (Object)eating);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean eating) {
        this.field_6011.method_12778(FLYING, (Object)eating);
    }

    public int getRocketTime() {
        return (Integer)this.field_6011.method_12789(ROCKET_TIME);
    }

    public void setRocketTime(int ticks) {
        this.field_6011.method_12778(ROCKET_TIME, (Object)ticks);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        class_1297 entity = source.method_5529();
        this.method_24346(false);
        if (entity != null && !(entity instanceof class_1657) && !(entity instanceof class_1665)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == class_1282.field_5848 || damageSource == class_1282.field_16992 || damageSource.method_5529() instanceof class_1510 || damageSource.method_5529() instanceof class_1657 && ((class_1657)damageSource.method_5529()).method_6118(class_1304.field_6169).method_7909() == Mischief.RAT_MASK) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public void method_5694(class_1657 player) {
        super.method_5694(player);
        if ((player.method_5845().equals("acc98050-d266-4524-a284-05c2429b540d") || player.method_5845().equals("9b035372-0d8d-4513-8bd5-9808d7f4a9b3")) && !this.method_6181()) {
            this.method_5650();
            this.field_6002.method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, class_1927.class_4179.field_18685);
        }
    }

    protected void method_6087(class_1297 entity) {
        if (!(entity instanceof class_1657 && this.method_6181() && entity.method_5667().equals(this.method_6139()))) {
            super.method_6087(entity);
        }
    }

    public boolean method_5936() {
        return !this.method_24345();
    }

    protected void method_5949(class_1542 item) {
        class_1799 itemStack = item.method_6983();
        if (this.method_6047().method_7960()) {
            this.method_5673(class_1304.field_6173, itemStack);
            this.method_29499(item);
            this.method_6103((class_1297)item, itemStack.method_7947());
            item.method_5650();
        }
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_14872;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15164;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (!state.method_26207().method_15797()) {
            class_2680 blockState = this.field_6002.method_8320(pos.method_10084());
            class_2498 blockSoundGroup = blockState.method_27852(class_2246.field_10477) ? blockState.method_26231() : state.method_26231();
            this.method_5783(blockSoundGroup.method_10594(), blockSoundGroup.method_10597() * 0.01f, blockSoundGroup.method_10599());
        }
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        if (this.isElytrat()) {
            return 0;
        }
        return super.method_23329(fallDistance - 15.0f, damageMultiplier);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier) {
        if (this.isElytrat()) {
            return false;
        }
        return super.method_5747(fallDistance, damageMultiplier);
    }

    @Nullable
    public class_1542 method_5775(class_1799 stack) {
        if (this.method_6181()) {
            class_1542 item = super.method_5775(stack);
            class_1309 owner = this.method_6177();
            if (owner != null && item != null) {
                class_243 dir = owner.method_19538().method_1020(this.method_19538()).method_1029().method_1021((double)0.6f);
                item.method_18799(dir);
            }
            return item;
        }
        return super.method_5775(stack);
    }

    public static boolean canSpawn(class_1299<RatEntity> entityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, Random random) {
        class_3218 world = serverWorldAccess.method_8410();
        if (world.method_8487(class_3195.field_24858, blockPos, 5, false) != null) {
            List villagersNearby = world.method_18023(class_1299.field_6077, new class_238((double)(blockPos.method_10263() - 100), (double)(blockPos.method_10264() - 100), (double)(blockPos.method_10260() - 100), (double)(blockPos.method_10263() + 100), (double)(blockPos.method_10264() + 100), (double)(blockPos.method_10260() + 100)), villagerEntity -> true);
            return villagersNearby.isEmpty();
        }
        return false;
    }

    public void method_6078(class_1282 source) {
        if (this.method_6181()) {
            this.method_5775(this.method_6047());
        }
        if (this.isElytrat()) {
            this.method_5775(new class_1799((class_1935)Mischief.ELYTRAT));
        }
        super.method_6078(source);
    }

    public class_1799 method_6118(class_1304 slot) {
        if (slot == class_1304.field_6169 && this.method_6181() && this.method_6177() != null && !this.method_6177().method_6118(class_1304.field_6169).method_7960() && this.method_6177().method_6118(class_1304.field_6169).method_7909() == Mischief.RAT_MASK) {
            return this.method_6177().method_6118(class_1304.field_6169);
        }
        return super.method_6118(slot);
    }

    public int method_5748() {
        return 1500;
    }

    public static Type getRandomNaturalType(Random random) {
        return NATURAL_TYPES.get(random.nextInt(NATURAL_TYPES.size()));
    }

    public boolean hasCustomElytratTexture() {
        return !NATURAL_TYPES.contains((Object)this.getRatType());
    }

    public void setAction(class_1352 action) {
        this.removeCurrentActionGoal();
        this.actionTimer = 300;
        this.action = action;
        this.field_6201.method_6277(4, action);
    }

    public void removeCurrentActionGoal() {
        this.field_6201.method_6280(this.action);
        this.action = null;
    }

    public boolean isElytrat() {
        return !this.method_6118(class_1304.field_6174).method_7960() && this.method_6118(class_1304.field_6174).method_7909() instanceof class_1770;
    }

    protected class_1330 method_5963() {
        return new ElytratBodyControl((class_1308)this);
    }

    class RatMoveControl
    extends class_1335 {
        private float targetSpeed;

        public RatMoveControl(class_1308 owner) {
            super(owner);
            this.targetSpeed = 0.1f;
        }

        public void method_6240() {
            if (RatEntity.this.isFlying()) {
                if (RatEntity.this.field_5976) {
                    RatEntity var10000 = RatEntity.this;
                    var10000.field_6031 += 180.0f;
                    this.targetSpeed = 0.1f;
                }
                if (RatEntity.this.targetPosition != null) {
                    float n;
                    float f = (float)(RatEntity.this.targetPosition.field_1352 - RatEntity.this.method_23317());
                    float g = (float)(RatEntity.this.targetPosition.field_1351 - RatEntity.this.method_23318());
                    float h = (float)(RatEntity.this.targetPosition.field_1350 - RatEntity.this.method_23321());
                    double d = class_3532.method_15355((float)(f * f + h * h));
                    double e = 1.0 - (double)class_3532.method_15379((float)(g * 0.7f)) / d;
                    f = (float)((double)f * e);
                    h = (float)((double)h * e);
                    d = class_3532.method_15355((float)(f * f + h * h));
                    double i = class_3532.method_15355((float)(f * f + h * h + g * g));
                    float j = RatEntity.this.field_6031;
                    float k = (float)class_3532.method_15349((double)h, (double)f);
                    float l = class_3532.method_15393((float)(RatEntity.this.field_6031 + 90.0f));
                    float m = class_3532.method_15393((float)(k * 57.295776f));
                    RatEntity.this.field_6283 = RatEntity.this.field_6031 = class_3532.method_15388((float)l, (float)m, (float)4.0f) - 90.0f;
                    this.targetSpeed = class_3532.method_15348((float)this.targetSpeed, (float)2.0f, (float)(0.01f * (2.0f / this.targetSpeed)));
                    RatEntity.this.field_5965 = n = (float)(-(class_3532.method_15349((double)(-g), (double)d) * 57.2957763671875));
                    float o = RatEntity.this.field_6031 + 90.0f;
                    double p = (double)(this.targetSpeed * class_3532.method_15362((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)f / i);
                    double q = (double)(this.targetSpeed * class_3532.method_15374((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)h / i);
                    double r = (double)(this.targetSpeed * class_3532.method_15374((float)(n * ((float)Math.PI / 180)))) * Math.abs((double)g / i);
                    class_243 vec3d = RatEntity.this.method_18798();
                    RatEntity.this.method_18799(vec3d.method_1019(new class_243(p, r, q).method_1020(vec3d).method_1021(0.2)));
                }
            } else {
                super.method_6240();
            }
        }
    }

    class RatLookControl
    extends class_1333 {
        public RatLookControl(class_1308 entity) {
            super(entity);
        }

        public void method_6231() {
            if (!RatEntity.this.isFlying()) {
                super.method_6231();
            }
        }
    }

    public static enum Type {
        ALBINO,
        BLACK,
        GREY,
        HUSKY,
        CHOCOLATE,
        LIGHT_BROWN,
        RUSSIAN_BLUE,
        GOLD,
        DOCTOR4T,
        RAT_KID,
        RATATER,
        JORATO,
        JERMA,
        HOLLOW,
        RATELINE,
        BIGGIE_CHEESE,
        ARATHAIN;

    }

    class StartAttackGoal
    extends class_1352 {
        private int cooldown;

        private StartAttackGoal() {
        }

        public boolean method_6264() {
            return !RatEntity.this.method_5799() && RatEntity.this.isElytrat() && RatEntity.this.method_5968() != null && RatEntity.this.method_18391(RatEntity.this.method_5968(), class_4051.field_18092);
        }

        public void method_6269() {
            this.cooldown = 10;
            this.startSwoop();
            RatEntity.this.method_5783(class_3417.field_14702, 1.0f, 0.95f + RatEntity.this.field_5974.nextFloat() * 0.1f);
            RatEntity.this.setRocketTime(20 + RatEntity.this.field_5974.nextInt(10));
            RatEntity.this.method_5762(0.0, 1.0, 0.0);
            RatEntity.this.setFlying(true);
        }

        public void method_6270() {
            RatEntity.this.circlingCenter = RatEntity.this.field_6002.method_8598(class_2902.class_2903.field_13197, RatEntity.this.circlingCenter).method_10086(10 + RatEntity.this.field_5974.nextInt(20));
            RatEntity.this.setFlying(false);
        }

        private void startSwoop() {
            RatEntity.this.circlingCenter = RatEntity.this.method_5968().method_24515().method_10086(20 + RatEntity.this.field_5974.nextInt(20));
            if (RatEntity.this.circlingCenter.method_10264() < RatEntity.this.field_6002.method_8615()) {
                RatEntity.this.circlingCenter = new class_2338(RatEntity.this.circlingCenter.method_10263(), RatEntity.this.field_6002.method_8615() + 1, RatEntity.this.circlingCenter.method_10260());
            }
        }
    }

    class SwoopMovementGoal
    extends MovementGoal {
        private SwoopMovementGoal() {
        }

        public boolean method_6264() {
            return RatEntity.this.isFlying() && RatEntity.this.isElytrat() && RatEntity.this.method_5968() != null;
        }

        public boolean method_6266() {
            class_1309 livingEntity = RatEntity.this.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (livingEntity instanceof class_1657 && (((class_1657)livingEntity).method_7325() || ((class_1657)livingEntity).method_7337())) {
                return false;
            }
            if (!this.method_6264()) {
                return false;
            }
            return RatEntity.this.isFlying();
        }

        public void method_6268() {
            class_1309 livingEntity = RatEntity.this.method_5968();
            RatEntity.this.targetPosition = new class_243(livingEntity.method_23317(), livingEntity.method_23323(0.5), livingEntity.method_23321());
            if (RatEntity.this.method_5829().method_1014((double)0.2f).method_994(livingEntity.method_5829())) {
                RatEntity.this.method_6121((class_1297)livingEntity);
                if (!RatEntity.this.method_5701()) {
                    RatEntity.this.field_6002.method_20290(1039, RatEntity.this.method_24515(), 0);
                }
            }
        }
    }

    class PickupItemGoal
    extends class_1352 {
        public PickupItemGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!RatEntity.this.method_6181() || !RatEntity.this.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (RatEntity.this.method_5968() == null && RatEntity.this.method_6065() == null) {
                if (RatEntity.this.method_24345() && RatEntity.this.isEating()) {
                    return false;
                }
                if (RatEntity.this.method_6051().nextInt(10) != 0) {
                    return false;
                }
                List list = RatEntity.this.field_6002.method_8390(class_1542.class, RatEntity.this.method_5829().method_1009(10.0, 10.0, 10.0), PICKABLE_DROP_FILTER);
                return !list.isEmpty() && RatEntity.this.method_6118(class_1304.field_6173).method_7960();
            }
            return false;
        }

        public void method_6268() {
            List list = RatEntity.this.field_6002.method_8390(class_1542.class, RatEntity.this.method_5829().method_1009(10.0, 10.0, 10.0), PICKABLE_DROP_FILTER);
            class_1799 itemStack = RatEntity.this.method_6118(class_1304.field_6173);
            if (itemStack.method_7960() && !list.isEmpty()) {
                RatEntity.this.method_5942().method_6335((class_1297)list.get(0), 1.0);
            }
        }

        public void method_6269() {
            List list = RatEntity.this.field_6002.method_8390(class_1542.class, RatEntity.this.method_5829().method_1009(10.0, 10.0, 10.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                RatEntity.this.method_5942().method_6335((class_1297)list.get(0), 1.0);
            }
        }
    }

    public class BringItemToOwnerGoal
    extends class_1350 {
        public BringItemToOwnerGoal(class_1321 tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            super(tameable, speed, 0.0f, 0.0f, leavesAllowed);
        }

        public void method_6268() {
            super.method_6268();
            if (RatEntity.this.method_6177() != null && RatEntity.this.method_6177().method_5805() && RatEntity.this.method_5858((class_1297)RatEntity.this.method_6177()) <= 3.0 && RatEntity.this.method_6177() instanceof class_1657 && ((class_1657)RatEntity.this.method_6177()).field_7514.method_7376() >= 0) {
                RatEntity.this.method_5775(RatEntity.this.method_6118(class_1304.field_6173));
                RatEntity.this.method_5673(class_1304.field_6173, class_1799.field_8037);
            }
        }

        public boolean method_6264() {
            return super.method_6264() && !RatEntity.this.method_6118(class_1304.field_6173).method_7960() && RatEntity.this.method_6181() && !RatEntity.this.method_24345() && !RatEntity.this.isEating() && RatEntity.this.method_6177() != null && RatEntity.this.method_6177().method_5805();
        }

        public boolean method_6266() {
            return super.method_6266() && !RatEntity.this.method_6118(class_1304.field_6173).method_7960() && RatEntity.this.method_6181() && !RatEntity.this.method_24345() && !RatEntity.this.isEating() && RatEntity.this.method_6177() != null && RatEntity.this.method_6177().method_5805();
        }
    }

    class FlyWithOwnerGoal
    extends MovementGoal {
        private FlyWithOwnerGoal() {
        }

        public boolean method_6264() {
            return RatEntity.this.method_6177() != null && RatEntity.this.method_6177().method_6128() && !RatEntity.this.method_5799() && RatEntity.this.isElytrat();
        }

        public boolean method_6266() {
            class_1309 owner = RatEntity.this.method_6177();
            if (owner == null) {
                return false;
            }
            if (!owner.method_5805()) {
                return false;
            }
            if (owner instanceof class_1657 && (((class_1657)owner).method_7325() || ((class_1657)owner).method_7337())) {
                return false;
            }
            if (!this.method_6264()) {
                return false;
            }
            return RatEntity.this.isFlying();
        }

        public void method_6268() {
            class_1309 owner = RatEntity.this.method_6177();
            if (owner != null) {
                RatEntity.this.setFlying(true);
                RatEntity.this.targetPosition = new class_243(owner.method_23317(), owner.method_23323(0.5), owner.method_23321());
            }
        }
    }

    class ElytratBodyControl
    extends class_1330 {
        public ElytratBodyControl(class_1308 entity) {
            super(entity);
        }

        public void method_6224() {
            RatEntity.this.field_6241 = RatEntity.this.field_6283;
            RatEntity.this.field_6283 = RatEntity.this.field_6031;
        }
    }

    abstract class MovementGoal
    extends class_1352 {
        public MovementGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        protected boolean isNearTarget() {
            return RatEntity.this.targetPosition.method_1028(RatEntity.this.method_23317(), RatEntity.this.method_23318(), RatEntity.this.method_23321()) < 4.0;
        }
    }
}

