/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.ratsmischief.common;

import com.mojang.brigadier.CommandDispatcher;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import ladysnake.ratsmischief.common.armormaterials.RatMaskArmorMaterial;
import ladysnake.ratsmischief.common.command.PlayerRatifyCommand;
import ladysnake.ratsmischief.common.command.PlayerUnratifyCommand;
import ladysnake.ratsmischief.common.entity.RatEntity;
import ladysnake.ratsmischief.common.item.RatPouchItem;
import ladysnake.ratsmischief.common.item.RatStaffItem;
import ladysnake.ratsmischief.common.village.MischiefTradeOffers;
import ladysnake.ratsmischief.common.world.RatSpawner;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1535;
import net.minecraft.class_1738;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import software.bernie.geckolib3.GeckoLib;

public class Mischief
implements ModInitializer {
    public static final String MODID = "ratsmischief";
    public static class_1299<RatEntity> RAT;
    public static final boolean IS_WORLD_RAT_DAY;
    public static class_1792 RAT_SPAWN_EGG;
    public static class_1792 LEATHER_RAT_POUCH;
    public static class_1792 TWISTED_RAT_POUCH;
    public static class_1792 PURPUR_RAT_POUCH;
    public static class_1792 HARVEST_STAFF;
    public static class_1792 COLLECTION_STAFF;
    public static class_1792 SKIRMISH_STAFF;
    public static class_1792 LOVE_STAFF;
    public static class_1792 RAT_MASK;
    public static class_1792 ELYTRAT;

    public void onInitialize() {
        GeckoLib.initialize();
        RAT = Mischief.registerEntity("rat", FabricEntityTypeBuilder.createMob().entityFactory(RatEntity::new).spawnGroup(class_1311.field_6303).dimensions(class_4048.method_18384((float)0.8f, (float)0.4f)).trackRangeBlocks(8).spawnRestriction(class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, RatEntity::canSpawn).build());
        FabricDefaultAttributeRegistry.register(RAT, (class_5132.class_5133)RatEntity.createEntityAttributes());
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> PlayerRatifyCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, b) -> PlayerUnratifyCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
        RatSpawner ratSpawner = new RatSpawner();
        ServerTickEvents.END_SERVER_TICK.register(server -> server.method_3738().forEach(world -> ratSpawner.method_6445((class_3218)world, server.method_27728().method_207() != class_1267.field_5801, server.method_3796())));
        RAT_SPAWN_EGG = Mischief.registerItem((class_1792)new class_1826(RAT, 0x1A1A1A, 15904161, new class_1792.class_1793().method_7892(class_1761.field_7932)), "rat_spawn_egg");
        LEATHER_RAT_POUCH = Mischief.registerItem(new RatPouchItem(new class_1792.class_1793().method_7892(class_1761.field_7930).method_7889(1), 5), "leather_rat_pouch");
        TWISTED_RAT_POUCH = Mischief.registerItem(new RatPouchItem(new class_1792.class_1793().method_7892(class_1761.field_7930).method_7889(1), 10), "twisted_rat_pouch");
        PURPUR_RAT_POUCH = Mischief.registerItem(new RatPouchItem(new class_1792.class_1793().method_7892(class_1761.field_7930).method_7889(1), 20), "purpur_rat_pouch");
        HARVEST_STAFF = Mischief.registerItem(new RatStaffItem(new class_1792.class_1793().method_7892(class_1761.field_7930).method_7889(1), RatStaffItem.Action.HARVEST), "harvest_staff");
        COLLECTION_STAFF = Mischief.registerItem(new RatStaffItem(new class_1792.class_1793().method_7892(class_1761.field_7930).method_7889(1), RatStaffItem.Action.COLLECT), "collection_staff");
        LOVE_STAFF = Mischief.registerItem(new RatStaffItem(new class_1792.class_1793().method_7892(class_1761.field_7930).method_7889(1), RatStaffItem.Action.LOVE), "love_staff");
        RAT_MASK = Mischief.registerItem((class_1792)new class_1738(RatMaskArmorMaterial.RAT_MASK, class_1304.field_6169, new class_1792.class_1793().method_7892(class_1761.field_7916)), "rat_mask");
        ELYTRAT = Mischief.registerItem(new class_1792(new class_1792.class_1793().method_7892(class_1761.field_7932).method_7889(16)), "elytrat");
        class_2378.method_10230((class_2378)class_2378.field_11150, (class_2960)new class_2960(MODID, "a_rat_in_time"), (Object)new class_1535(64, 48));
        TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> factories.add(new MischiefTradeOffers.SellItemFactory(RAT_MASK, 40, 1, 3, 40)));
    }

    private static <T extends class_1297> class_1299<T> registerEntity(String s, class_1299<T> entityType) {
        return (class_1299)class_2378.method_10226((class_2378)class_2378.field_11145, (String)("ratsmischief:" + s), entityType);
    }

    public static class_1792 registerItem(class_1792 item, String name) {
        class_2378.method_10226((class_2378)class_2378.field_11142, (String)("ratsmischief:" + name), (Object)item);
        return item;
    }

    static {
        IS_WORLD_RAT_DAY = DateTimeFormatter.ofPattern("dd/MM").format(LocalDateTime.now()).equals("04/04");
    }
}

