/*
 * Decompiled with CFR 0.152.
 */
package com.WildlyEat;

import com.WildlyEat.ClientPacketHandler;
import com.WildlyEat.SpitPacketHandler;
import com.WildlyEat.WildlyEat;
import com.WildlyEat.WildlyEatConfig;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class EatenPacketHandler {
    public int item;
    public int block;
    public int entity;
    public BlockPos blockpos = new BlockPos(0, 0, 0);
    public static HashMap<UUID, EatDate> Eat = new HashMap();

    public EatenPacketHandler() {
    }

    public EatenPacketHandler(int item, int block, int entity, BlockPos blockpos) {
        this.item = item;
        this.block = block;
        this.entity = entity;
        this.blockpos = blockpos;
    }

    public static EatenPacketHandler decode(PacketBuffer buffer) {
        int item = buffer.readInt();
        int block = buffer.readInt();
        int entity = buffer.readInt();
        BlockPos blockpos = buffer.func_179259_c();
        return new EatenPacketHandler(item, block, entity, blockpos);
    }

    public static void encode(EatenPacketHandler msg, PacketBuffer buffer) {
        buffer.writeInt(msg.item);
        buffer.writeInt(msg.block);
        buffer.writeInt(msg.entity);
        buffer.func_179255_a(msg.blockpos);
    }

    public WildlyEat.EatType GetType() {
        if (this.item != 0 && ((Boolean)WildlyEatConfig.item.get()).booleanValue()) {
            return WildlyEat.EatType.item;
        }
        if (this.entity != 0 && ((Boolean)WildlyEatConfig.entity.get()).booleanValue()) {
            return WildlyEat.EatType.entity;
        }
        if (this.block != 0 && ((Boolean)WildlyEatConfig.block.get()).booleanValue()) {
            return WildlyEat.EatType.block;
        }
        return WildlyEat.EatType.None;
    }

    public int GetId(boolean Entity2) {
        switch (this.GetType()) {
            case item: {
                return this.item;
            }
            case block: {
                return this.block;
            }
            case entity: {
                if (Entity2) {
                    return this.entity;
                }
                return Item.func_150891_b((Item)Items.field_151147_al);
            }
        }
        return Item.func_150891_b((Item)Items.field_221582_j);
    }

    static int GetEatenTime(WildlyEat.EatType type, ServerWorld world, int id) {
        int NeedTime = 5;
        switch (type) {
            case block: {
                Block block = Block.func_149634_a((Item)Item.func_150899_d((int)id));
                NeedTime = NeedTime * 2 * MathHelper.func_76125_a((int)block.getHarvestLevel(block.func_176223_P()), (int)1, (int)5);
                break;
            }
            case item: {
                Block block = Block.func_149634_a((Item)Item.func_150899_d((int)id));
                NeedTime *= MathHelper.func_76125_a((int)block.getHarvestLevel(block.func_176223_P()), (int)1, (int)5);
                break;
            }
            case entity: {
                if (world.func_73045_a(id) instanceof EnderDragonPartEntity) {
                    NeedTime = 50;
                    break;
                }
                if (!(world.func_73045_a(id) instanceof LivingEntity)) break;
                LivingEntity entity = (LivingEntity)world.func_73045_a(id);
                NeedTime = (int)((float)(NeedTime * 2) * MathHelper.func_76131_a((float)(entity.func_110138_aP() / 2.0f), (float)1.0f, (float)5.0f));
            }
        }
        for (String Set2 : (List)WildlyEatConfig.EatSetList.get()) {
            String[] Sets = Set2.split(",");
            if (!EatenPacketHandler.GetResourceLocation(type, id, world, Sets[0]).booleanValue()) continue;
            return Integer.parseInt(Sets[1]);
        }
        return (int)((double)NeedTime * (Double)WildlyEatConfig.ConsumeCountMultiple.get());
    }

    static ResourceLocation GetResourceLocation(WildlyEat.EatType type, int id, ServerWorld world) {
        switch (type) {
            case item: 
            case block: {
                return Item.func_150899_d((int)id).getRegistryName();
            }
            case entity: {
                Entity entity = world.func_73045_a(id);
                if (entity instanceof ServerPlayerEntity) {
                    return new ResourceLocation("minecraft", "player");
                }
                if (entity instanceof EnderDragonPartEntity) {
                    return ((EnderDragonPartEntity)entity).field_213852_b.func_200600_R().getRegistryName();
                }
                if (entity instanceof LivingEntity || entity instanceof Entity) {
                    return entity.func_200600_R().getRegistryName();
                }
                return new ResourceLocation("minecraft", "unknown");
            }
        }
        return Items.field_221582_j.getRegistryName();
    }

    static Boolean GetResourceLocation(WildlyEat.EatType type, int id, ServerWorld world, String path) {
        return EatenPacketHandler.MatchResourceLocation(type, EatenPacketHandler.GetResourceLocation(type, id, world), path);
    }

    static Boolean MatchResourceLocation(WildlyEat.EatType type, ResourceLocation Resource, String path) {
        if (path.equals("item") && type == WildlyEat.EatType.item || path.equals("entity") && type == WildlyEat.EatType.entity || path.equals("block") && type == WildlyEat.EatType.block) {
            return true;
        }
        String[] paths = path.split(":");
        if (Resource.func_110624_b().equals(paths[0]) && (paths[1].equals("item") && type == WildlyEat.EatType.item || paths[1].equals("entity") && type == WildlyEat.EatType.entity || paths[1].equals("block") && type == WildlyEat.EatType.block)) {
            return true;
        }
        return Resource.toString().equals(path);
    }

    public static void SendClient(boolean spawn, boolean Switch, int id, ServerPlayerEntity player) {
        ClientPacketHandler ClientPacket = new ClientPacketHandler(id, (Integer)WildlyEatConfig.ParticleCount.get(), spawn, Switch, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), player.field_70125_A, player.field_70177_z, player.func_70047_e());
        if (spawn) {
            WildlyEat.Network.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)player.func_213303_ch().func_82615_a(), (double)player.func_213303_ch().func_82617_b(), (double)player.func_213303_ch().func_82616_c(), (double)8.0, (RegistryKey)player.func_130014_f_().func_234923_W_())), (Object)ClientPacket);
        } else {
            WildlyEat.Network.send(PacketDistributor.PLAYER.with(() -> player), (Object)ClientPacket);
        }
    }

    public static void handle(EatenPacketHandler msg, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        ServerWorld serverworld = player.func_71121_q();
        WildlyEat.EatType type = msg.GetType();
        int id = msg.GetId(true);
        BlockPos pos = msg.blockpos;
        UUID uuid = player.func_110124_au();
        EatDate Date = Eat.getOrDefault(player.func_110124_au(), new EatDate());
        if (type == WildlyEat.EatType.None || System.currentTimeMillis() < Date.CoolDown) {
            return;
        }
        if (((Boolean)WildlyEatConfig.EnableEatWhiteList.get()).booleanValue()) {
            boolean White = false;
            for (String list : (List)WildlyEatConfig.EatWhiteList.get()) {
                if (!EatenPacketHandler.GetResourceLocation(type, id, serverworld, list).booleanValue()) continue;
                White = true;
                break;
            }
            if (!White) {
                return;
            }
        }
        for (String list : (List)WildlyEatConfig.EatBlackList.get()) {
            if (!EatenPacketHandler.GetResourceLocation(type, id, serverworld, list).booleanValue()) continue;
            return;
        }
        if (!((Boolean)WildlyEatConfig.AlwaysEdible.get()).booleanValue() && !player.func_71024_bL().func_75121_c()) {
            return;
        }
        if (!EatenPacketHandler.GetResourceLocation(type, id, serverworld, Date.LastEatenObject).booleanValue()) {
            Date.EatTime = 0;
            Date.DamageInterval = 0;
            EatenPacketHandler.SendClient(false, false, 0, player);
        }
        Date.LastEatenObject = EatenPacketHandler.GetResourceLocation(type, id, serverworld).toString();
        ctx.get().enqueueWork(() -> {
            if (Date.EatTime < EatenPacketHandler.GetEatenTime(type, serverworld, id)) {
                Entity entity = serverworld.func_73045_a(id);
                if (type == WildlyEat.EatType.item) {
                    EatenPacketHandler.SendClient(false, true, 0, player);
                }
                if (type == WildlyEat.EatType.entity) {
                    LivingEntity LiveEntity = null;
                    if (entity instanceof LivingEntity) {
                        LiveEntity = (LivingEntity)entity;
                    } else if (entity instanceof EnderDragonPartEntity) {
                        LiveEntity = ((EnderDragonPartEntity)entity).field_213852_b;
                    }
                    if (LiveEntity != null) {
                        for (String EffectList : (List)WildlyEatConfig.EatEntityEffectList.get()) {
                            String[] effect = EffectList.split(",");
                            LiveEntity.func_195064_c(new EffectInstance(((EffectInstance)Potion.func_185168_a((String)effect[0]).func_185170_a().get(0)).func_188419_a(), Integer.parseInt(effect[1]), Integer.parseInt(effect[2])));
                        }
                        if (LiveEntity.func_110143_aJ() > (float)((Integer)WildlyEatConfig.EntityDamage.get()).intValue()) {
                            if (Date.DamageInterval >= (Integer)WildlyEatConfig.EntityDamageInterval.get()) {
                                EntityDamageSource PlayerEaten = new EntityDamageSource("PlayerEaten", (Entity)player).func_180138_v();
                                PlayerEaten.func_76348_h().func_76359_i().func_82726_p();
                                if (((Boolean)WildlyEatConfig.EnablePlayerDamage.get()).booleanValue() && LiveEntity instanceof ServerPlayerEntity) {
                                    serverworld.func_184148_a(null, player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, (serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                                    player.func_71024_bL().func_75122_a(2, 1.0f);
                                    LiveEntity.func_70097_a((DamageSource)PlayerEaten, (float)((Integer)WildlyEatConfig.EntityDamage.get()).intValue());
                                    EatenPacketHandler.PutSpitList(4, EatenPacketHandler.RandomPlayerDrop(serverworld.field_73012_v), uuid, WildlyEat.EatType.item);
                                } else if (((Boolean)WildlyEatConfig.EnableEntityDamage.get()).booleanValue()) {
                                    serverworld.func_184148_a(null, player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, (serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                                    player.func_71024_bL().func_75122_a(2, 1.0f);
                                    LiveEntity.func_70097_a((DamageSource)PlayerEaten, (float)((Integer)WildlyEatConfig.EntityDamage.get()).intValue());
                                    LootTable loottable = serverworld.func_73046_m().func_200249_aQ().func_186521_a(LiveEntity.func_213346_cF());
                                    LootContext.Builder lootcontext$builder = new LootContext.Builder(serverworld).func_216023_a(serverworld.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)LiveEntity).func_216015_a(LootParameters.field_237457_g_, (Object)player.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)PlayerEaten).func_216021_b(LootParameters.field_216284_d, (Object)PlayerEaten.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)PlayerEaten.func_76364_f());
                                    LootContext context = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
                                    loottable.func_216113_a(context).forEach(item -> EatenPacketHandler.PutSpitList(4, item.func_77955_b(new CompoundNBT()), uuid, WildlyEat.EatType.item));
                                }
                                Date.DamageInterval = 0;
                            } else {
                                ++Date.DamageInterval;
                            }
                        }
                    }
                }
                EatenPacketHandler.SendClient(true, type == WildlyEat.EatType.block, msg.GetId(false), player);
                serverworld.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.5f, (serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                ++Date.EatTime;
                Eat.put(uuid, Date);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            } else {
                Date.CoolDown = System.currentTimeMillis() + (long)((Integer)WildlyEatConfig.EatenCoolDown.get()).intValue();
                if (type == WildlyEat.EatType.item) {
                    EatenPacketHandler.SendClient(false, false, 0, player);
                }
                Date.EatTime = 0;
                Eat.put(uuid, Date);
                int foodLevel = 1;
                float foodSaturationLevel = 1.0f;
                CompoundNBT Nbt = new CompoundNBT();
                Boolean NotFood = true;
                switch (type) {
                    case item: {
                        ItemStack hand = player.func_184614_ca();
                        if (!((Boolean)WildlyEatConfig.BlockItemSpitItem.get()).booleanValue() && Block.func_149634_a((Item)hand.func_77973_b()) != Blocks.field_150350_a) {
                            EatenPacketHandler.FallBlockNbt(Nbt, hand.func_77973_b().getRegistryName().toString());
                        } else {
                            Nbt = hand.func_77955_b(Nbt);
                            Nbt.func_74774_a("Count", (byte)1);
                        }
                        if (hand.func_77973_b().func_219971_r()) {
                            foodLevel = hand.func_77973_b().func_219967_s().func_221466_a();
                            foodSaturationLevel = hand.func_77973_b().func_219967_s().func_221469_b();
                            player.func_213357_a((World)serverworld, hand);
                            NotFood = false;
                            break;
                        }
                        if (PotionUtils.func_185189_a((ItemStack)hand) != null) {
                            for (EffectInstance PotionEffect : PotionUtils.func_185189_a((ItemStack)hand)) {
                                if (PotionEffect.func_188419_a().func_76403_b()) {
                                    PotionEffect.func_188419_a().func_180793_a((Entity)player, (Entity)player, (LivingEntity)player, PotionEffect.func_76458_c(), 1.0);
                                    continue;
                                }
                                player.func_195064_c(new EffectInstance(PotionEffect));
                            }
                        }
                        hand.func_190918_g(1);
                        break;
                    }
                    case block: {
                        Block block = serverworld.func_180495_p(pos).func_177230_c();
                        ItemStack item2 = block.getPickBlock(block.func_176223_P(), null, (IBlockReader)serverworld, pos, (PlayerEntity)player);
                        if (item2 != null) {
                            if (!((Boolean)WildlyEatConfig.BlockSpitItem.get()).booleanValue() && Block.func_149634_a((Item)item2.func_77973_b()) != Blocks.field_150350_a) {
                                EatenPacketHandler.FallBlockNbt(Nbt, item2.func_77973_b().getRegistryName().toString());
                            } else {
                                Nbt = item2.func_77955_b(Nbt);
                            }
                        }
                        serverworld.func_175655_b(pos, false);
                        break;
                    }
                    case entity: {
                        LivingEntity LiveEntity;
                        Entity entity = serverworld.func_73045_a(id);
                        if (entity == null) break;
                        if (entity instanceof ServerPlayerEntity) {
                            LiveEntity = (LivingEntity)entity;
                            EntityDamageSource PlayerEaten = new EntityDamageSource("PlayerEaten", (Entity)player).func_180138_v();
                            PlayerEaten.func_76348_h().func_76359_i().func_82726_p();
                            LiveEntity.func_70097_a((DamageSource)PlayerEaten, 2.1474836E9f);
                            EatenPacketHandler.PutSpitList(4, EatenPacketHandler.RandomPlayerDrop(serverworld.field_73012_v), uuid, WildlyEat.EatType.item);
                            foodLevel = 2;
                            foodSaturationLevel = 1.0f;
                            break;
                        }
                        Nbt.func_74757_a("EatenSpawn", true);
                        if (entity instanceof EnderDragonPartEntity) {
                            LiveEntity = ((EnderDragonPartEntity)entity).field_213852_b;
                            Nbt = LiveEntity.func_189511_e(Nbt);
                            Nbt.func_74778_a("id", LiveEntity.func_200600_R().getRegistryName().toString());
                            LiveEntity.func_174812_G();
                            foodLevel = 20;
                            foodSaturationLevel = 20.0f;
                            break;
                        }
                        if (entity instanceof LivingEntity) {
                            LiveEntity = (LivingEntity)entity;
                            Nbt = LiveEntity.func_189511_e(Nbt);
                            Nbt.func_74778_a("id", LiveEntity.func_70022_Q());
                            foodLevel = (int)LiveEntity.func_110138_aP();
                            foodSaturationLevel = 1.0f;
                            LiveEntity.func_70106_y();
                            break;
                        }
                        Nbt = entity.func_189511_e(Nbt);
                        Nbt.func_74778_a("id", entity.func_70022_Q());
                        entity.func_70106_y();
                        break;
                    }
                }
                for (String Set2 : (List)WildlyEatConfig.EatSetList.get()) {
                    String[] Sets = Set2.split(",");
                    if (!EatenPacketHandler.GetResourceLocation(type, id, serverworld, Sets[0]).booleanValue()) continue;
                    foodLevel = Integer.parseInt(Sets[2]);
                    foodSaturationLevel = Float.parseFloat(Sets[3]);
                }
                if (Nbt.func_74779_i("id") != "") {
                    EatenPacketHandler.PutSpitList(foodLevel + 1, Nbt, uuid, type);
                }
                if (NotFood.booleanValue()) {
                    player.func_71024_bL().func_75122_a(foodLevel, foodSaturationLevel);
                    serverworld.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, (serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                }
                ArrayList<String> MatchEffects = new ArrayList<String>();
                for (String EffectSet : (List)WildlyEatConfig.EatEffectSetList.get()) {
                    if (!EatenPacketHandler.GetResourceLocation(type, id, serverworld, EffectSet.split(",")[0]).booleanValue()) continue;
                    MatchEffects.add(EffectSet.substring(EffectSet.indexOf(",") + 1));
                }
                for (String MatchEffect : MatchEffects) {
                    EatenPacketHandler.SpecialEffects(serverworld, player, MatchEffect);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void SpecialEffects(ServerWorld serverworld, ServerPlayerEntity player, String MatchEffect) {
        String[] EffectSets = MatchEffect.split(",");
        int length = EffectSets.length;
        switch (EffectSets[0]) {
            case "OnlyOne": {
                String GroupStarts = MatchEffect.substring(MatchEffect.indexOf(",") + 1);
                GroupStarts = GroupStarts.substring(GroupStarts.indexOf(",") + 1);
                String[] Groups = GroupStarts.split("[/]");
                if (length > 1 && Float.parseFloat(EffectSets[1]) < serverworld.field_73012_v.nextFloat()) {
                    EatenPacketHandler.SpecialEffects(serverworld, player, Groups[0]);
                    break;
                }
                EatenPacketHandler.SpecialEffects(serverworld, player, Groups[1]);
                break;
            }
            case "EffectGroup": {
                if (length > 1 && Float.parseFloat(EffectSets[1]) < serverworld.field_73012_v.nextFloat()) break;
                String GroupStart = MatchEffect.substring(MatchEffect.indexOf(",") + 1);
                GroupStart = GroupStart.substring(GroupStart.indexOf(",") + 1);
                for (String Group : GroupStart.split("[|]")) {
                    EatenPacketHandler.SpecialEffects(serverworld, player, Group);
                }
                break;
            }
            case "ClearAllEffect": {
                if (length > 1 && Float.parseFloat(EffectSets[1]) < serverworld.field_73012_v.nextFloat()) break;
                player.func_195061_cb();
                break;
            }
            case "Explosion": {
                if (length > 2 && Float.parseFloat(EffectSets[2]) < serverworld.field_73012_v.nextFloat()) break;
                serverworld.func_217385_a((Entity)player, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), Float.parseFloat(EffectSets[1]), Explosion.Mode.DESTROY);
                break;
            }
            case "SetFoodState": {
                if (length > 3 && Float.parseFloat(EffectSets[3]) < serverworld.field_73012_v.nextFloat()) break;
                if (EffectSets[1].startsWith("-") || EffectSets[1].startsWith("+")) {
                    player.func_71024_bL().func_75122_a(Integer.parseInt(EffectSets[1]), Float.parseFloat(EffectSets[2]));
                    break;
                }
                player.func_71024_bL().func_75114_a(Integer.parseInt(EffectSets[1]));
                player.func_71024_bL().func_75119_b(Float.parseFloat(EffectSets[2]));
                break;
            }
            case "GiveItem": 
            case "DropItem": {
                if (length > 3 && Float.parseFloat(EffectSets[3]) < serverworld.field_73012_v.nextFloat()) break;
                ItemStack ItemStack2 = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(EffectSets[1])), Integer.parseInt(EffectSets[2]));
                if (length > 4) {
                    try {
                        ItemStack2.readShareTag(JsonToNBT.func_180713_a((String)MatchEffect.split("NBT")[1]));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                EatenPacketHandler.SendClient(true, false, 0, player);
                if (EffectSets[0].equals("GiveItem") && player.func_191521_c(ItemStack2)) {
                    serverworld.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 1.0f + (serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.2f);
                    break;
                }
                serverworld.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_191255_dF, SoundCategory.PLAYERS, 1.0f, 1.0f + (serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.2f);
                player.func_71019_a(ItemStack2, false);
                break;
            }
            case "Lightning": {
                if (length > 2 && Float.parseFloat(EffectSets[2]) < serverworld.field_73012_v.nextFloat()) break;
                LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)serverworld);
                player.func_70097_a(DamageSource.field_180137_b, (float)Integer.parseInt(EffectSets[1]));
                lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)player.func_233580_cy_()));
                lightningboltentity.func_233623_a_(true);
                serverworld.func_217376_c((Entity)lightningboltentity);
                break;
            }
            case "SpawnEntity": {
                if (length > 3 && Float.parseFloat(EffectSets[3]) < serverworld.field_73012_v.nextFloat()) break;
                CompoundNBT compoundnbt = new CompoundNBT();
                if (length > 4) {
                    try {
                        compoundnbt = JsonToNBT.func_180713_a((String)MatchEffect.split("NBT")[1]);
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                compoundnbt.func_74778_a("id", EffectSets[1]);
                for (int e = 0; e < Integer.parseInt(EffectSets[2]); ++e) {
                    MobEntity entity = (MobEntity)EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)serverworld, p_218914_1_ -> {
                        p_218914_1_.func_70107_b(player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c());
                        return p_218914_1_;
                    });
                    entity.func_213293_j(player.func_70040_Z().func_82615_a(), player.func_70040_Z().func_82617_b(), player.func_70040_Z().func_82616_c());
                    serverworld.func_217376_c((Entity)entity);
                }
                EatenPacketHandler.SendClient(true, false, 0, player);
                serverworld.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_191255_dF, SoundCategory.PLAYERS, 1.0f, 1.0f + (serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.2f);
                break;
            }
            case "GiveExp": {
                if (length > 2 && Float.parseFloat(EffectSets[2]) < serverworld.field_73012_v.nextFloat()) break;
                player.func_195068_e(Integer.parseInt(EffectSets[1]));
                serverworld.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, ((serverworld.field_73012_v.nextFloat() - serverworld.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                break;
            }
            case "PotionEffect": {
                Effect Potion2;
                if (length > 4 && Float.parseFloat(EffectSets[4]) < serverworld.field_73012_v.nextFloat() || (Potion2 = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(EffectSets[1]))) == null) break;
                int Duration = Integer.parseInt(EffectSets[2]);
                int Amplifier = Integer.parseInt(EffectSets[3]);
                if (player.func_70644_a(Potion2)) {
                    Duration += player.func_70660_b(Potion2).func_76459_b();
                    if (player.func_70660_b(Potion2).func_76458_c() > Amplifier) {
                        Amplifier = player.func_70660_b(Potion2).func_76458_c();
                    }
                    player.func_195064_c(new EffectInstance(Potion2, Duration, Amplifier));
                    break;
                }
                player.func_195064_c(new EffectInstance(Potion2, Duration, Amplifier));
            }
        }
    }

    public static void FallBlockNbt(CompoundNBT nbt, String BlockId) {
        CompoundNBT BlockState2 = new CompoundNBT();
        BlockState2.func_74778_a("Name", BlockId);
        nbt.func_74757_a("EatenSpawn", true);
        nbt.func_74757_a("HurtEntities", true);
        nbt.func_74778_a("id", "minecraft:falling_block");
        nbt.func_74768_a("Time", 1);
        nbt.func_218657_a("BlockState", (INBT)BlockState2);
    }

    public static CompoundNBT RandomPlayerDrop(Random random) {
        if (random.nextBoolean()) {
            return new ItemStack((IItemProvider)Items.field_151147_al, 1).func_77955_b(new CompoundNBT());
        }
        return new ItemStack((IItemProvider)Items.field_151103_aS, 1).func_77955_b(new CompoundNBT());
    }

    public static void PutSpitList(int foodLevel, CompoundNBT NBT, UUID uuid, WildlyEat.EatType type) {
        List SpitList;
        if (NBT.func_74779_i("id") == null || !((Boolean)WildlyEatConfig.spit.get()).booleanValue() || (Integer)WildlyEatConfig.SpitMaxCount.get() == 0) {
            return;
        }
        if (((Boolean)WildlyEatConfig.EnableSpitBlackList.get()).booleanValue()) {
            for (String SpitBlack : (List)WildlyEatConfig.SpitBlackList.get()) {
                if (!EatenPacketHandler.MatchResourceLocation(type, new ResourceLocation(NBT.func_74779_i("id")), SpitBlack).booleanValue()) continue;
                return;
            }
        }
        if (((Boolean)WildlyEatConfig.EnableSpitEffectList.get()).booleanValue()) {
            for (String EffectList : (List)WildlyEatConfig.EatEffectSetList.get()) {
                if (!EffectList.split(",")[0].equals(NBT.func_74779_i("id"))) continue;
                return;
            }
        }
        if ((SpitList = (List)SpitPacketHandler.Spit.getOrDefault(uuid, new ArrayList())).size() + 1 > (Integer)WildlyEatConfig.SpitMaxCount.get()) {
            SpitList.remove(0);
        }
        NBT.func_74778_a("EatenType", type.toString());
        NBT.func_74768_a("EatenFoodLevel", (int)((double)foodLevel * (Double)WildlyEatConfig.SpitExpendMultiple.get()));
        SpitList.add(NBT);
        SpitPacketHandler.Spit.put(uuid, SpitList);
    }

    static class EatDate {
        int EatTime = 0;
        Long CoolDown = 0L;
        int DamageInterval = 0;
        String LastEatenObject = "None";

        EatDate() {
        }
    }
}

