/*
 * Decompiled with CFR 0.152.
 */
package com.WildlyEat;

import com.WildlyEat.KeyInputHandler;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientPacketHandler {
    public int Id;
    public int ParticlesCount;
    public boolean particles;
    public boolean Switch;
    public double x;
    public double y;
    public double z;
    public float rotationPitch;
    public float rotationYaw;
    public float EyeHeight;

    public ClientPacketHandler(int Id, int ParticlesCount, boolean particles, boolean Switch, double x, double y, double z, float rotationPitch, float rotationYaw, float EyeHeight) {
        this.Id = Id;
        this.ParticlesCount = ParticlesCount;
        this.particles = particles;
        this.Switch = Switch;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotationPitch = rotationPitch;
        this.rotationYaw = rotationYaw;
        this.EyeHeight = EyeHeight;
    }

    public static ClientPacketHandler decode(PacketBuffer buffer) {
        int Id = buffer.readInt();
        int ParticlesCount = buffer.readInt();
        boolean particles = buffer.readBoolean();
        boolean Switch = buffer.readBoolean();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        float rotationPitch = buffer.readFloat();
        float rotationYaw = buffer.readFloat();
        float EyeHeight = buffer.readFloat();
        return new ClientPacketHandler(Id, ParticlesCount, particles, Switch, x, y, z, rotationPitch, rotationYaw, EyeHeight);
    }

    public static void encode(ClientPacketHandler msg, PacketBuffer buffer) {
        buffer.writeInt(msg.Id);
        buffer.writeInt(msg.ParticlesCount);
        buffer.writeBoolean(msg.particles);
        buffer.writeBoolean(msg.Switch);
        buffer.writeDouble(msg.x);
        buffer.writeDouble(msg.y);
        buffer.writeDouble(msg.z);
        buffer.writeFloat(msg.rotationPitch);
        buffer.writeFloat(msg.rotationYaw);
        buffer.writeFloat(msg.EyeHeight);
    }

    public static void handle(ClientPacketHandler msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (msg.particles) {
                ClientWorld word = Minecraft.func_71410_x().field_71441_e;
                for (int i = 0; i < msg.ParticlesCount; ++i) {
                    Vector3d vector3d = new Vector3d(((double)word.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vector3d = vector3d.func_178789_a(-msg.rotationPitch * ((float)Math.PI / 180));
                    vector3d = vector3d.func_178785_b(-msg.rotationYaw * ((float)Math.PI / 180));
                    double d0 = (double)(-word.field_73012_v.nextFloat()) * 0.6 - 0.3;
                    Vector3d vector3d1 = new Vector3d(((double)word.field_73012_v.nextFloat() - 0.5) * 0.3, d0, 0.6);
                    vector3d1 = vector3d1.func_178789_a(-msg.rotationPitch * ((float)Math.PI / 180));
                    vector3d1 = vector3d1.func_178785_b(-msg.rotationYaw * ((float)Math.PI / 180));
                    vector3d1 = vector3d1.func_72441_c(msg.x, msg.y + (double)msg.EyeHeight, msg.z);
                    if (msg.Switch) {
                        word.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Block.func_149634_a((Item)Item.func_150899_d((int)msg.Id)).func_176223_P()), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
                        continue;
                    }
                    if (msg.Id != 0) {
                        word.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, Item.func_150899_d((int)msg.Id).func_190903_i()), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
                        continue;
                    }
                    word.func_195594_a((IParticleData)ParticleTypes.field_218422_X, vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
                }
            } else if (msg.Switch) {
                KeyInputHandler.IsEat = true;
            } else {
                KeyInputHandler.FpsTick = 0.0f;
                KeyInputHandler.FpsShakeTick = 0.0f;
                KeyInputHandler.ClientTick = 0.0f;
                KeyInputHandler.ClientShakeTick = 0.0f;
                KeyInputHandler.ShakeOne = false;
                KeyInputHandler.IsEat = false;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

