/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur.util;

import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class ShaderResourcePack
implements IResourcePack,
ISelectiveResourceReloadListener {
    private final ModFile blurModFile = FMLLoader.getLoadingModList().getModFileById("blur").getFile();
    private final Map<ResourceLocation, String> loadedData = new HashMap<ResourceLocation, String>();

    protected boolean validPath(ResourceLocation location) {
        return location.func_110624_b().equals("minecraft") && location.func_110623_a().startsWith("shaders/");
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        if (type == ResourcePackType.CLIENT_RESOURCES && this.validPath(location)) {
            try {
                return Files.newInputStream(this.blurModFile.findResource(location.func_110623_a()), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + location.func_110623_a());
            }
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        return type == ResourcePackType.CLIENT_RESOURCES && this.validPath(location) && Files.exists(this.blurModFile.findResource(location.func_110623_a()), new LinkOption[0]);
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        return type == ResourcePackType.CLIENT_RESOURCES ? ImmutableSet.of((Object)"minecraft") : Collections.emptySet();
    }

    public <T> T func_195760_a(IMetadataSectionSerializer<T> arg0) throws IOException {
        if ("pack".equals(arg0.func_110483_a())) {
            return (T)new PackMetadataSection((ITextComponent)new StringTextComponent("Blur's default shaders"), 3);
        }
        return null;
    }

    public String func_195762_a() {
        return "Blur dummy resource pack";
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.loadedData.clear();
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType p_225637_1_, String p_225637_2_, String p_225637_3_, int p_225637_4_, Predicate<String> p_225637_5_) {
        return Collections.emptyList();
    }

    public InputStream func_195763_b(String arg0) throws IOException {
        return Files.newInputStream(this.blurModFile.findResource("assets/blur/" + arg0), new OpenOption[0]);
    }

    public void close() {
    }
}

