/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.client.model.armor;

import goblinbob.mobends.core.bender.EntityBender;
import goblinbob.mobends.core.bender.EntityBenderRegistry;
import goblinbob.mobends.core.client.model.BoxFactory;
import goblinbob.mobends.core.client.model.BoxMutator;
import goblinbob.mobends.core.client.model.IModelPart;
import goblinbob.mobends.core.client.model.ModelPart;
import goblinbob.mobends.core.client.model.ModelPartContainer;
import goblinbob.mobends.core.client.model.ModelPartTransform;
import goblinbob.mobends.core.client.model.MutatedBox;
import goblinbob.mobends.core.data.EntityDatabase;
import goblinbob.mobends.core.util.ModelUtils;
import goblinbob.mobends.standard.client.model.armor.PartGroup;
import goblinbob.mobends.standard.data.BipedEntityData;
import goblinbob.mobends.standard.data.PlayerData;
import goblinbob.mobends.standard.previewer.PlayerPreviewer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import org.lwjgl.util.vector.Vector3f;

public class MutatedArmorModel
extends ModelBiped {
    protected ModelBiped original;
    protected List<Field> gatheredFields;
    protected HashMap<Field, ModelRenderer> fieldToOriginalMap;
    protected HashMap<ModelRenderer, ModelBox> modelToBoxMap;
    protected HashMap<ModelRenderer, IModelPart> originalToCustomMap;
    protected boolean mutated = false;
    protected EntityBender<EntityLivingBase> lastEntityBender;
    protected ModelPartTransform mainBodyTransform;
    protected List<PartGroup<BipedEntityData<?>>> partGroups;
    protected PartGroup<BipedEntityData<?>> bodyParts;
    protected PartGroup<BipedEntityData<?>> headParts;
    protected PartGroup<BipedEntityData<?>> leftArmParts;
    protected PartGroup<BipedEntityData<?>> rightArmParts;
    protected PartGroup<BipedEntityData<?>> leftLegParts;
    protected PartGroup<BipedEntityData<?>> rightLegParts;
    protected PartGroup<BipedEntityData<?>> leftForeArmParts;
    protected PartGroup<BipedEntityData<?>> rightForeArmParts;
    protected PartGroup<BipedEntityData<?>> leftForeLegParts;
    protected PartGroup<BipedEntityData<?>> rightForeLegParts;

    public MutatedArmorModel(ModelBiped original) {
        this.original = original;
        this.gatheredFields = new ArrayList<Field>();
        this.fieldToOriginalMap = new HashMap();
        this.modelToBoxMap = new HashMap();
        this.originalToCustomMap = new HashMap();
        this.mainBodyTransform = new ModelPartTransform();
        this.partGroups = new ArrayList();
        this.bodyParts = new PartGroup<BipedEntityData>(data -> data.body, model -> model.field_78115_e);
        this.partGroups.add(this.bodyParts);
        this.headParts = new PartGroup<BipedEntityData>(data -> data.head, model -> model.field_78116_c);
        this.partGroups.add(this.headParts);
        this.leftArmParts = new PartGroup<BipedEntityData>(data -> data.leftArm, model -> model.field_178724_i);
        this.partGroups.add(this.leftArmParts);
        this.rightArmParts = new PartGroup<BipedEntityData>(data -> data.rightArm, model -> model.field_178723_h);
        this.partGroups.add(this.rightArmParts);
        this.leftLegParts = new PartGroup<BipedEntityData>(data -> data.leftLeg, model -> model.field_178722_k);
        this.partGroups.add(this.leftLegParts);
        this.rightLegParts = new PartGroup<BipedEntityData>(data -> data.rightLeg, model -> model.field_178721_j);
        this.partGroups.add(this.rightLegParts);
        this.leftForeArmParts = new PartGroup<BipedEntityData>(data -> data.leftForeArm, model -> model.field_178724_i);
        this.partGroups.add(this.leftForeArmParts);
        this.rightForeArmParts = new PartGroup<BipedEntityData>(data -> data.rightForeArm, model -> model.field_178723_h);
        this.partGroups.add(this.rightForeArmParts);
        this.leftForeLegParts = new PartGroup<BipedEntityData>(data -> data.leftForeLeg, model -> model.field_178722_k);
        this.partGroups.add(this.leftForeLegParts);
        this.rightForeLegParts = new PartGroup<BipedEntityData>(data -> data.rightForeLeg, model -> model.field_178721_j);
        this.partGroups.add(this.rightForeLegParts);
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
        EntityBender<EntityLivingBase> entityBender = EntityBenderRegistry.instance.getForEntity(entityLiving);
        if (entityBender == null) {
            return;
        }
        Object entityData = EntityDatabase.instance.get(entityLiving);
        if (!(entityData instanceof BipedEntityData)) {
            return;
        }
        this.lastEntityBender = entityBender;
        if (entityBender.isAnimated() && !this.mutated) {
            this.mutate();
        } else if (!entityBender.isAnimated() && this.mutated) {
            this.demutate();
        }
        BipedEntityData dataBiped = (BipedEntityData)entityData;
        this.updateVisibility();
        GlStateManager.func_179094_E();
        this.original.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (entityIn.func_70093_af()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.2, (double)0.0);
        }
        if (this.field_78091_s) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
        }
        this.renderPartGroups(this.leftForeArmParts, scale, dataBiped.body, dataBiped.leftArm);
        this.renderPartGroups(this.rightForeArmParts, scale, dataBiped.body, dataBiped.rightArm);
        this.renderPartGroups(this.leftForeLegParts, scale, dataBiped.leftLeg);
        this.renderPartGroups(this.rightForeLegParts, scale, dataBiped.rightLeg);
        GlStateManager.func_179121_F();
    }

    private void renderPartGroups(PartGroup<BipedEntityData<?>> group, float scale, ModelPartTransform ... dependencies) {
        GlStateManager.func_179094_E();
        for (ModelPartTransform dependency : dependencies) {
            dependency.applyLocalTransform(scale);
        }
        group.getParts().forEach(part -> part.renderPart(scale));
        GlStateManager.func_179121_F();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        this.original.func_178686_a((ModelBase)this);
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
        Object entityData = EntityDatabase.instance.get(entityLiving);
        if (!(entityData instanceof BipedEntityData)) {
            return;
        }
        if (entityData instanceof PlayerData && PlayerPreviewer.isPreviewInProgress()) {
            entityData = PlayerPreviewer.getPreviewData();
        }
        BipedEntityData dataBiped = (BipedEntityData)entityData;
        this.mainBodyTransform.syncUp(dataBiped.body);
        this.partGroups.forEach(group -> group.syncUp(dataBiped));
    }

    protected void updateVisibility() {
        this.partGroups.forEach(group -> group.updateVisibility(this));
        for (Map.Entry<ModelRenderer, IModelPart> entry : this.originalToCustomMap.entrySet()) {
            if (!entry.getValue().isShowing()) continue;
            entry.getValue().setVisible(entry.getKey().field_78806_j && !entry.getKey().field_78807_k);
        }
    }

    protected void mutate() {
        if (this.mutated) {
            this.demutate();
        }
        this.partGroups.forEach(PartGroup::clear);
        this.gatheredFields.clear();
        this.fieldToOriginalMap.clear();
        this.modelToBoxMap.clear();
        this.originalToCustomMap.clear();
        this.gatherFields(this.original.getClass());
        for (Field f : this.gatheredFields) {
            System.out.println("ArmorField: " + f);
            try {
                ModelPartContainer container;
                ModelRenderer modelRenderer = (ModelRenderer)f.get(this.original);
                if (modelRenderer == null) continue;
                if (modelRenderer instanceof ModelPartContainer) {
                    container = (ModelPartContainer)modelRenderer;
                } else {
                    System.out.println("Added to fieldToOriginalMap " + modelRenderer);
                    this.fieldToOriginalMap.put(f, modelRenderer);
                    container = this.mutatePart(modelRenderer);
                    container.field_78809_i = modelRenderer.field_78809_i;
                }
                this.assignPart(container);
                f.set(this.original, container);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.sliceParts();
        this.positionParts();
        this.mutated = true;
    }

    public void demutate() {
        for (Field field : this.gatheredFields) {
            if (!this.fieldToOriginalMap.containsKey(field)) continue;
            System.out.println("Retrieved from fieldToOriginalMap " + this.fieldToOriginalMap.get(field));
            try {
                field.set(this.original, this.fieldToOriginalMap.get(field));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        for (ModelRenderer modelRenderer : this.modelToBoxMap.keySet()) {
            modelRenderer.field_78804_l.clear();
        }
        for (Map.Entry entry : this.modelToBoxMap.entrySet()) {
            ((ModelRenderer)entry.getKey()).field_78804_l.add(entry.getValue());
        }
        this.gatheredFields.clear();
        this.fieldToOriginalMap.clear();
        this.modelToBoxMap.clear();
        this.originalToCustomMap.clear();
        this.partGroups.forEach(PartGroup::clear);
        this.mutated = false;
    }

    public void updateMutation() {
        if (this.lastEntityBender == null) {
            return;
        }
        if (this.lastEntityBender.isAnimated() && !this.mutated) {
            this.mutate();
        } else if (!this.lastEntityBender.isAnimated() && this.mutated) {
            this.demutate();
        }
    }

    protected void gatherFields(Class<?> modelClass) {
        Field[] fields;
        for (Field f : fields = modelClass.getDeclaredFields()) {
            if (!ModelRenderer.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            this.gatheredFields.add(f);
        }
        if (modelClass.getSuperclass() != null) {
            this.gatherFields(modelClass.getSuperclass());
        }
    }

    protected ModelPartContainer mutatePart(ModelRenderer modelRenderer) {
        return new ModelPartContainer((ModelBase)this, modelRenderer);
    }

    protected void assignPart(ModelPartContainer container) {
        ModelRenderer part = container.getModel();
        ModelRenderer rootParent = ModelUtils.getRootParent(part, this.fieldToOriginalMap.values());
        if (rootParent == null) {
            rootParent = part;
        }
        Vector3f globalOrigin = ModelUtils.getGlobalOrigin(part, this.fieldToOriginalMap.values());
        AxisAlignedBB bounds = ModelUtils.getBounds(part);
        System.out.println("Bounds: " + bounds);
        if (globalOrigin.y >= 11.0f) {
            if (globalOrigin.x < 0.0f) {
                this.rightLegParts.add(container);
            } else {
                this.leftLegParts.add(container);
            }
        } else if (globalOrigin.x <= -5.0f || part.field_78804_l != null && part.field_78804_l.size() > 0 && part.field_78800_c + ((ModelBox)part.field_78804_l.get((int)0)).field_78252_a <= -6.0f) {
            this.rightArmParts.add(container);
        } else if (globalOrigin.x >= 5.0f || part.field_78804_l != null && part.field_78804_l.size() > 0 && part.field_78800_c + ((ModelBox)part.field_78804_l.get((int)0)).field_78248_d >= 6.0f) {
            this.leftArmParts.add(container);
        } else if (part.field_78804_l != null && part.field_78804_l.size() > 0 && bounds.field_72337_e >= 4.0) {
            this.bodyParts.add(container);
        } else {
            this.headParts.add(container);
        }
    }

    protected void positionParts() {
        this.headParts.forEach(part -> part.setParent(this.mainBodyTransform));
        this.bodyParts.forEach(part -> part.setInnerOffset(0.0f, -12.0f, 0.0f));
        this.leftArmParts.forEach(part -> {
            part.setInnerOffset(-5.0f, -2.0f, 0.0f);
            part.setParent(this.mainBodyTransform);
        });
        this.rightArmParts.forEach(part -> {
            part.setInnerOffset(5.0f, -2.0f, 0.0f);
            part.setParent(this.mainBodyTransform);
        });
        this.leftForeArmParts.forEach(part -> part.setInnerOffset(0.0f, -4.0f, -2.0f));
        this.rightForeArmParts.forEach(part -> part.setInnerOffset(0.0f, -4.0f, -2.0f));
        this.leftLegParts.forEach(part -> part.setInnerOffset(0.0f, -12.0f, 0.0f));
        this.rightLegParts.forEach(part -> part.setInnerOffset(0.0f, -12.0f, 0.0f));
        this.leftForeLegParts.forEach(part -> part.setInnerOffset(2.0f, -6.0f, 2.0f));
        this.rightForeLegParts.forEach(part -> part.setInnerOffset(-2.0f, -6.0f, 2.0f));
    }

    protected void sliceAppendage(ModelPartContainer part, PartGroup targetGroup, float cutPlane) {
        ModelRenderer originalPart = part.getModel();
        for (int i = originalPart.field_78804_l.size() - 1; i >= 0; --i) {
            ModelBox box = (ModelBox)originalPart.field_78804_l.get(i);
            BoxMutator mutator = BoxMutator.createFrom((ModelBase)this, originalPart, box);
            if (mutator == null) continue;
            mutator.includeParentTransform(ModelUtils.getParentsList(originalPart, this.fieldToOriginalMap.values()));
            this.modelToBoxMap.put(originalPart, box);
            part.getModel().field_78804_l.remove(box);
            if (mutator.getGlobalBoxY() < cutPlane) {
                BoxFactory lowerPartFactory = mutator.sliceFromBottom(cutPlane, true);
                MutatedBox topPart = mutator.getFactory().create(part);
                part.getModel().field_78804_l.add(topPart);
                if (lowerPartFactory == null) continue;
                ModelPart modelPart = new ModelPart((ModelBase)this, mutator.getTextureOffsetX(), mutator.getTextureOffsetY());
                modelPart.field_78809_i = part.field_78809_i;
                MutatedBox lowerPart = lowerPartFactory.create(modelPart);
                modelPart.field_78804_l.add(lowerPart);
                ModelPartContainer partContainer = new ModelPartContainer((ModelBase)this, modelPart);
                targetGroup.add(partContainer);
                this.originalToCustomMap.put(originalPart, partContainer);
                continue;
            }
            ModelPart modelPart = new ModelPart((ModelBase)this, mutator.getTextureOffsetX(), mutator.getTextureOffsetY());
            modelPart.field_78809_i = part.field_78809_i;
            MutatedBox lowerBox = mutator.getFactory().create(modelPart);
            modelPart.field_78804_l.add(lowerBox);
            ModelPartContainer partContainer = new ModelPartContainer((ModelBase)this, modelPart);
            targetGroup.add(partContainer);
            this.originalToCustomMap.put(originalPart, partContainer);
        }
    }

    protected void sliceParts() {
        this.leftLegParts.forEach(part -> this.sliceAppendage((ModelPartContainer)part, this.leftForeLegParts, 18.0f));
        this.rightLegParts.forEach(part -> this.sliceAppendage((ModelPartContainer)part, this.rightForeLegParts, 18.0f));
        this.leftArmParts.forEach(part -> this.sliceAppendage((ModelPartContainer)part, this.leftForeArmParts, 6.0f));
        this.rightArmParts.forEach(part -> this.sliceAppendage((ModelPartContainer)part, this.rightForeArmParts, 6.0f));
    }

    public static MutatedArmorModel createFrom(ModelBiped src) {
        MutatedArmorModel customModel = new MutatedArmorModel(src);
        customModel.mutate();
        return customModel;
    }
}

