/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.controller;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.core.animation.controller.IAnimationController;
import goblinbob.mobends.core.animation.layer.HardAnimationLayer;
import goblinbob.mobends.standard.animation.bit.biped.AttackSlashInwardAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.BowAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.HarvestAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.JumpAnimationBit;
import goblinbob.mobends.standard.animation.bit.skeleton.StandAnimationBit;
import goblinbob.mobends.standard.animation.bit.skeleton.WalkAnimationBit;
import goblinbob.mobends.standard.data.BipedEntityData;
import goblinbob.mobends.standard.data.SkeletonData;
import goblinbob.mobends.standard.main.ModConfig;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumHandSide;

public class SkeletonController
implements IAnimationController<SkeletonData> {
    protected HardAnimationLayer<BipedEntityData<EntitySkeleton>> layerBase;
    protected HardAnimationLayer<BipedEntityData<?>> layerAction;
    protected AnimationBit<? extends BipedEntityData<EntitySkeleton>> bitStand;
    protected AnimationBit<? extends BipedEntityData<EntitySkeleton>> bitWalk;
    protected AnimationBit<? extends BipedEntityData<EntitySkeleton>> bitJump;
    protected AttackSlashInwardAnimationBit bitAttack = new AttackSlashInwardAnimationBit();
    protected BowAnimationBit bitBow = new BowAnimationBit();
    protected HarvestAnimationBit bitHarvest = new HarvestAnimationBit();

    public SkeletonController() {
        this.layerBase = new HardAnimationLayer();
        this.layerAction = new HardAnimationLayer();
        this.bitStand = new StandAnimationBit();
        this.bitWalk = new WalkAnimationBit();
        this.bitJump = new JumpAnimationBit<BipedEntityData<EntitySkeleton>>();
    }

    public static boolean isHoldingBow(ModelBiped.ArmPose mainArmPose, ModelBiped.ArmPose offArmPose) {
        return mainArmPose == ModelBiped.ArmPose.BOW_AND_ARROW || offArmPose == ModelBiped.ArmPose.BOW_AND_ARROW;
    }

    public static boolean isHoldingWeapon(Item heldItemMainhand) {
        return heldItemMainhand instanceof ItemSword || ModConfig.isItemWeapon(heldItemMainhand);
    }

    public void performActionAnimations(SkeletonData data, EntitySkeleton skeleton) {
        ModelBiped.ArmPose armPoseOff;
        EnumHandSide primaryHand = skeleton.func_184591_cq();
        EnumHandSide offHand = primaryHand == EnumHandSide.RIGHT ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
        ItemStack heldItemMainhand = skeleton.func_184614_ca();
        ItemStack heldItemOffhand = skeleton.func_184592_cb();
        ModelBiped.ArmPose armPoseMain = this.getAction(skeleton, heldItemMainhand);
        if (SkeletonController.isHoldingBow(armPoseMain, armPoseOff = this.getAction(skeleton, heldItemOffhand))) {
            this.bitBow.setActionHand(armPoseMain == ModelBiped.ArmPose.BOW_AND_ARROW ? primaryHand : offHand);
            this.layerAction.playOrContinueBit(this.bitBow, data);
        } else if (SkeletonController.isHoldingWeapon(heldItemMainhand.func_77973_b()) || heldItemMainhand.func_190926_b()) {
            this.layerAction.playOrContinueBit(this.bitAttack, data);
        } else {
            this.bitHarvest.setActionHand(primaryHand);
            if (skeleton.field_82175_bq) {
                this.layerAction.playOrContinueBit(this.bitHarvest, data);
            } else {
                this.layerAction.clearAnimation();
            }
        }
    }

    @Override
    public Collection<String> perform(SkeletonData skeletonData) {
        EntitySkeleton skeleton = (EntitySkeleton)skeletonData.getEntity();
        if (!skeletonData.isOnGround() || skeletonData.getTicksAfterTouchdown() < 1.0f) {
            this.layerBase.playOrContinueBit(this.bitJump, skeletonData);
        } else if (skeletonData.isStillHorizontally()) {
            this.layerBase.playOrContinueBit(this.bitStand, skeletonData);
        } else {
            this.layerBase.playOrContinueBit(this.bitWalk, skeletonData);
        }
        this.performActionAnimations(skeletonData, skeleton);
        ArrayList<String> actions = new ArrayList<String>();
        this.layerBase.perform(skeletonData, actions);
        this.layerAction.perform(skeletonData, actions);
        return actions;
    }

    private ModelBiped.ArmPose getAction(EntitySkeleton skeleton, ItemStack heldItem) {
        if (!heldItem.func_190926_b()) {
            if (skeleton.func_184605_cv() > 0) {
                EnumAction enumaction = heldItem.func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    return ModelBiped.ArmPose.BLOCK;
                }
                if (enumaction == EnumAction.BOW) {
                    return ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
            return ModelBiped.ArmPose.ITEM;
        }
        return ModelBiped.ArmPose.EMPTY;
    }
}

