/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.model;

import goblinbob.mobends.core.client.model.BoxFactory;
import goblinbob.mobends.core.client.model.BoxSide;
import java.util.Collection;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TexturedQuad;

public class BoxMutator {
    protected ModelBase targetModel;
    protected ModelRenderer targetRenderer;
    protected BoxFactory factory;
    protected int textureOffsetX;
    protected int textureOffsetY;
    protected float globalBoxX;
    protected float globalBoxY;
    protected float globalBoxZ;

    public BoxMutator(ModelBase targetModel, ModelRenderer targetRenderer, BoxFactory factory, int textureOffsetX, int textureOffsetY) {
        this.targetModel = targetModel;
        this.targetRenderer = targetRenderer;
        this.factory = factory;
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
        this.globalBoxX = this.targetRenderer.field_78800_c + this.factory.min.x;
        this.globalBoxY = this.targetRenderer.field_78797_d + this.factory.min.y;
        this.globalBoxZ = this.targetRenderer.field_78798_e + this.factory.min.z;
    }

    public static BoxMutator createFrom(ModelBase modelBase, ModelRenderer modelRenderer, ModelBox original) {
        TexturedQuad[] quadList = original.field_78254_i;
        if (quadList == null) {
            return null;
        }
        float x = original.field_78252_a;
        float y = original.field_78250_b;
        float z = original.field_78251_c;
        int width = (int)(original.field_78248_d - original.field_78252_a);
        int height = (int)(original.field_78249_e - original.field_78250_b);
        int length = (int)(original.field_78246_f - original.field_78251_c);
        float textureWidth = modelRenderer.field_78801_a;
        float textureHeight = modelRenderer.field_78799_b;
        int texU = (int)(quadList[1].field_78239_a[1].field_78241_b * textureWidth);
        int texV = (int)(quadList[2].field_78239_a[1].field_78242_c * textureHeight);
        if (modelRenderer.field_78809_i) {
            texV = (int)(quadList[3].field_78239_a[1].field_78242_c * textureHeight);
        }
        float inflation1 = Math.abs((float)((double)original.field_78252_a - quadList[1].field_78239_a[0].field_78243_a.field_72450_a));
        float inflation2 = Math.abs((float)((double)original.field_78248_d - quadList[1].field_78239_a[0].field_78243_a.field_72450_a));
        float inflation = Math.min(inflation1, inflation2);
        BoxFactory target = new BoxFactory(modelRenderer, original);
        target.inflate(inflation, inflation, inflation);
        return new BoxMutator(modelBase, modelRenderer, target, texU, texV);
    }

    public BoxFactory getFactory() {
        return this.factory;
    }

    public int getTextureOffsetX() {
        return this.textureOffsetX;
    }

    public int getTextureOffsetY() {
        return this.textureOffsetY;
    }

    public float getGlobalBoxX() {
        return this.globalBoxX;
    }

    public float getGlobalBoxY() {
        return this.globalBoxY;
    }

    public float getGlobalBoxZ() {
        return this.globalBoxZ;
    }

    public void includeParentTransform(ModelRenderer parentRenderer) {
        this.globalBoxX += parentRenderer.field_78800_c;
        this.globalBoxY += parentRenderer.field_78797_d;
        this.globalBoxZ += parentRenderer.field_78798_e;
    }

    public void includeParentTransform(Collection<ModelRenderer> parentsList) {
        for (ModelRenderer parent : parentsList) {
            this.includeParentTransform(parent);
        }
    }

    public void offsetBasedOnNewOrigin(float originX, float originY, float originZ) {
        float offsetX = originX - this.globalBoxX;
        float offsetY = originY - this.globalBoxY;
        float offsetZ = originZ - this.globalBoxZ;
        this.factory.offset(-offsetX, -offsetY, -offsetZ);
    }

    public void offsetBackBasedOnNewOrigin(float originX, float originY, float originZ) {
        float offsetX = originX - this.globalBoxX;
        float offsetY = originY - this.globalBoxY;
        float offsetZ = originZ - this.globalBoxZ;
        this.factory.offset(offsetX, offsetY, offsetZ);
    }

    public BoxFactory sliceFromBottom(float sliceY, boolean preservePositions) {
        float height = this.factory.max.y - this.factory.min.y;
        float localSliceY = sliceY - this.globalBoxY;
        if (localSliceY > this.factory.min.y && localSliceY < this.factory.max.y) {
            BoxSide[] faces;
            float newHeight = localSliceY;
            BoxFactory.TextureFace[] slidesFaces = new BoxFactory.TextureFace[6];
            for (BoxSide faceEnum : faces = new BoxSide[]{BoxSide.BACK, BoxSide.FRONT, BoxSide.LEFT, BoxSide.RIGHT}) {
                float textureOffset = newHeight / height;
                BoxFactory.TextureFace face = this.factory.faces[faceEnum.faceIndex];
                int sliceV = (int)((float)face.vPos + (float)face.vSize * textureOffset);
                slidesFaces[faceEnum.faceIndex] = new BoxFactory.TextureFace(face.uPos, sliceV, face.uSize, face.vPos + face.vSize - sliceV);
                face.vSize = sliceV - face.vPos;
            }
            slidesFaces[BoxSide.TOP.faceIndex] = new BoxFactory.TextureFace(this.factory.faces[BoxSide.TOP.faceIndex]);
            slidesFaces[BoxSide.BOTTOM.faceIndex] = new BoxFactory.TextureFace(this.factory.faces[BoxSide.BOTTOM.faceIndex]);
            float slicedY = preservePositions ? localSliceY : 0.0f;
            BoxFactory sliced = new BoxFactory(this.factory.min.x, localSliceY, this.factory.min.z, this.factory.max.x, this.factory.max.y, this.factory.max.z, slidesFaces);
            sliced.hideFace(BoxSide.TOP);
            this.factory.max.setY(localSliceY + this.factory.min.y);
            this.factory.hideFace(BoxSide.BOTTOM);
            return sliced;
        }
        return null;
    }
}

