/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.wellbehavedmobs.common.element;

import com.fuzs.puzzleslib_wbm.element.AbstractElement;
import com.fuzs.puzzleslib_wbm.element.ISidedElement;
import com.fuzs.wellbehavedmobs.common.ai.RangedBowEasyAttackGoal;
import com.fuzs.wellbehavedmobs.mixin.accessor.IAbstractSkeletonEntityAccessor;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class SkeletonAttackElement
extends AbstractElement
implements ISidedElement.Common {
    public boolean quickBowDrawing;
    public boolean escapeTarget;

    @Override
    public String getDescription() {
        return "Remove the very annoying and buggy strafing behavior from skeletons when attacking.";
    }

    @Override
    public void setupCommon() {
        this.addListener(this::onEntityJoinWorld);
    }

    @Override
    public void setupCommonConfig(ForgeConfigSpec.Builder builder) {
        SkeletonAttackElement.addToConfig(builder.comment("Skeletons will shoot faster the closer their target moves to them.").define("Quick Bow Drawing", true), v -> {
            this.quickBowDrawing = v;
        });
        SkeletonAttackElement.addToConfig(builder.comment("Makes skeletons slowly walk backwards when their target moves in to close to them.").define("Escape Target", false), v -> {
            this.escapeTarget = v;
        });
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof AbstractSkeletonEntity) {
            AbstractSkeletonEntity skeleton = (AbstractSkeletonEntity)evt.getEntity();
            ItemStack stack = skeleton.func_184614_ca();
            RangedBowEasyAttackGoal<AbstractSkeletonEntity> aiArrowAttack = new RangedBowEasyAttackGoal<AbstractSkeletonEntity>(skeleton, 1.0, 40, 60, 15.0f);
            if (stack.func_77973_b() instanceof BowItem) {
                skeleton.field_70714_bg.func_85156_a(((IAbstractSkeletonEntityAccessor)skeleton).getAiArrowAttack());
                skeleton.field_70714_bg.func_75776_a(4, aiArrowAttack);
            }
            ((IAbstractSkeletonEntityAccessor)skeleton).setAiArrowAttack(aiArrowAttack);
        }
    }
}

