/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.wellbehavedmobs.common.element;

import com.fuzs.puzzleslib_wbm.element.AbstractElement;
import com.fuzs.puzzleslib_wbm.element.ISidedElement;
import com.fuzs.wellbehavedmobs.mixin.accessor.IGoalSelectorAccessor;
import com.fuzs.wellbehavedmobs.mixin.accessor.IHurtByTargetGoalAccessor;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class HelplessBlazesElement
extends AbstractElement
implements ISidedElement.Common {
    private boolean noCallForHelp;

    @Override
    public String getDescription() {
        return "Blazes don't call their buddies for help when attacking anymore and have a decreased follow range.";
    }

    @Override
    public void setupCommon() {
        this.addListener(this::onEntityJoinWorld);
    }

    @Override
    public void setupCommonConfig(ForgeConfigSpec.Builder builder) {
        HelplessBlazesElement.addToConfig(builder.comment("Other blazes aren't alerted when a blaze is fighting a player.").define("No Call For Help", true), v -> {
            this.noCallForHelp = v;
        });
        HelplessBlazesElement.addToConfig(builder.comment("Decrease follow range to 32 blocks from 48.").define("Decrease Follow Range", true), this::setFollowRangeAttribute);
    }

    @Override
    public void unload() {
        this.setFollowRangeAttribute(false);
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        if (this.noCallForHelp && evt.getEntity() instanceof BlazeEntity) {
            this.disableCallForHelp((BlazeEntity)evt.getEntity());
        }
    }

    private void disableCallForHelp(BlazeEntity blazeEntity) {
        ((IGoalSelectorAccessor)blazeEntity.field_70714_bg).getGoals().stream().map(PrioritizedGoal::func_220772_j).filter(goal -> goal instanceof HurtByTargetGoal).findFirst().map(goal -> (IHurtByTargetGoalAccessor)goal).ifPresent(goal -> goal.setEntityCallsForHelp(false));
    }

    private void setFollowRangeAttribute(boolean decrease) {
        GlobalEntityTypeAttributes.put((EntityType)EntityType.field_200792_f, (AttributeModifierMap)(decrease ? BlazeEntity.func_234276_m_().func_233815_a_(Attributes.field_233819_b_, 32.0).func_233813_a_() : BlazeEntity.func_234276_m_().func_233813_a_()));
    }
}

