/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.wellbehavedmobs.common.element;

import com.fuzs.puzzleslib_wbm.element.AbstractElement;
import com.fuzs.puzzleslib_wbm.element.ISidedElement;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class ChilledEndermenElement
extends AbstractElement
implements ISidedElement.Common {
    private boolean chilledAttackSpeed;

    @Override
    public String getDescription() {
        return "Endermen aren't lightning fast and can't sense you from the other end of the world anymore.";
    }

    @Override
    public void setupCommon() {
        this.addListener(this::onLivingSetAttackTarget);
    }

    @Override
    public void setupCommonConfig(ForgeConfigSpec.Builder builder) {
        ChilledEndermenElement.addToConfig(builder.comment("Enderman don't run even faster when attacking.").define("Chilled Attack Speed", true), v -> {
            this.chilledAttackSpeed = v;
        });
        ChilledEndermenElement.addToConfig(builder.comment("Decrease follow range to 32 blocks from a ridiculously high 64 block count.").define("Decrease Follow Range", false), this::setFollowRangeAttribute);
    }

    @Override
    public void unload() {
        this.setFollowRangeAttribute(false);
    }

    private void onLivingSetAttackTarget(LivingSetAttackTargetEvent evt) {
        if (this.chilledAttackSpeed && evt.getEntity() instanceof EndermanEntity) {
            UUID attackingSpeedBoostId = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
            ModifiableAttributeInstance attribute = ((EndermanEntity)evt.getEntity()).func_110148_a(Attributes.field_233821_d_);
            if (attribute != null) {
                Optional.ofNullable(attribute.func_111127_a(attackingSpeedBoostId)).ifPresent(arg_0 -> ((ModifiableAttributeInstance)attribute).func_111124_b(arg_0));
            }
        }
    }

    private void setFollowRangeAttribute(boolean decrease) {
        GlobalEntityTypeAttributes.put((EntityType)EntityType.field_200803_q, (AttributeModifierMap)(decrease ? EndermanEntity.func_234287_m_().func_233815_a_(Attributes.field_233819_b_, 32.0).func_233813_a_() : EndermanEntity.func_234287_m_().func_233813_a_()));
    }
}

