/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.wellbehavedmobs.common.element;

import com.fuzs.puzzleslib_wbm.element.AbstractElement;
import com.fuzs.puzzleslib_wbm.element.ISidedElement;
import com.fuzs.wellbehavedmobs.mixin.accessor.IAvoidEntityGoalAccessor;
import com.fuzs.wellbehavedmobs.mixin.accessor.IGoalSelectorAccessor;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class BraveRabbitsElement
extends AbstractElement
implements ISidedElement.Common {
    @Override
    public String getDescription() {
        return "Change rabbit ai for them to no longer be scared as easily. Also add some basic animal behaviour (such as kits following their parents) which for some reason is missing by default.";
    }

    @Override
    public void setupCommon() {
        this.addListener(this::onEntityJoinWorld);
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof RabbitEntity) {
            RabbitEntity rabbitEntity = (RabbitEntity)evt.getEntity();
            this.clearOldGoals(rabbitEntity);
            this.registerNewGoals(rabbitEntity);
        }
    }

    private void clearOldGoals(RabbitEntity rabbitEntity) {
        Set<Goal> goalsToRemove = this.getGoalsToRemove(((IGoalSelectorAccessor)rabbitEntity.field_70714_bg).getGoals(), rabbitEntity.func_175531_cl() != 99);
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)rabbitEntity.field_70714_bg).func_85156_a(arg_0));
    }

    private Set<Goal> getGoalsToRemove(Set<PrioritizedGoal> goals, boolean isNormalRabbit) {
        return goals.stream().map(PrioritizedGoal::func_220772_j).filter(goal -> !(goal instanceof MoveToBlockGoal) && !(goal instanceof MeleeAttackGoal) && !(goal instanceof PanicGoal) && (!(goal instanceof AvoidEntityGoal) || ((IAvoidEntityGoalAccessor)goal).getClassToAvoid() == WolfEntity.class || !isNormalRabbit)).collect(Collectors.toSet());
    }

    private void registerNewGoals(RabbitEntity rabbitEntity) {
        rabbitEntity.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)rabbitEntity));
        rabbitEntity.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)rabbitEntity, 1.1));
        Ingredient breedingItems = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF, Items.field_151150_bK, Blocks.field_196605_bc});
        rabbitEntity.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)rabbitEntity, 1.33, breedingItems, false));
        rabbitEntity.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)rabbitEntity, 1.2));
        rabbitEntity.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)rabbitEntity, 1.1));
        rabbitEntity.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)rabbitEntity, PlayerEntity.class, 6.0f));
        rabbitEntity.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)rabbitEntity));
    }
}

